/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SingleMemberClassAnnotation;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import com.openinventor.inventor.nodes.SoNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class SoMFEnum<EnumType extends Enum<EnumType>>
extends SoMField {
    protected Class<EnumType> m_enumTypeClass;

    protected SoMFEnum(Inventor.ConstructorCommand constructorCommand, long l, Class<EnumType> clazz) {
        super(constructorCommand, l);
        this.initializeFields();
        this.m_enumTypeClass = clazz;
    }

    private static native boolean equalsImpl(long var0, long var2);

    private static native int[] getValuesImpl(long var0, int var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native int getValueAtImpl(long var0, int var2);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValueImpl(long var0, int var2);

    private static native void set1ValueImpl(long var0, int var2, int var3);

    private static native void setValuesImpl(long var0, int var2, int var3, int[] var4);

    private static native int findImpl(long var0, int var2, boolean var3);

    private static native long getValueSizeImpl(long var0);

    private static native long ctorImpl();

    private static native void addEnumValueNative(long var0, String var2, String var3, int var4);

    private static native void setEnumTypeNative(long var0, long var2, String var4);

    private static native void setValueImpl1(long var0, String var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native void finishEditingImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFEnum.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void set1ValueImpl1(long var0, int var2, String var3);

    private static native Object startEditingImpl(long var0);

    protected SoMFEnum(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(int n) {
        return this.find(n, false);
    }

    @Deprecated
    public SoMFEnum() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFEnum.ctorImplSync());
    }

    @Deprecated
    public int get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = this.getValueAt(n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public IntBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFEnum.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asIntBuffer();
    }

    public int getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoMFEnum.getValueAtImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFEnum(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, @SingleMemberClassAnnotation(value="@sharpen.remove") Class<EnumType> clazz) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFEnum.ctorImplSync());
        this.m_enumTypeClass = clazz;
        SoMFEnum.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
        String string2 = clazz.getSimpleName();
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            String string3 = enum_.toString();
            int n = ((IntegerValuedEnum)Enum.valueOf(clazz, string3)).getValue();
            SoMFEnum.addEnumValueNative(soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string2, string3, n);
        }
        if (SoNode.class.isAssignableFrom(soFieldContainer.getClass())) {
            SoMFEnum.setEnumTypeNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string2);
        }
    }

    public IntBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFEnum.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asIntBuffer();
    }

    public void setValue(String string) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.setValueImpl1(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            int[] nArray = SoMFEnum.getValuesImpl(this.getNativeResourceHandle(), n);
            return nArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFEnum.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, String string) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.set1ValueImpl1(this.getNativeResourceHandle(), n, string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFEnum) {
            SoMFEnum soMFEnum = (SoMFEnum)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFEnum.equalsImpl(this.getNativeResourceHandle(), soMFEnum.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int[] nArray) {
        int n2 = nArray != null ? nArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.setValuesImpl(this.getNativeResourceHandle(), n, n2, nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(int n, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoMFEnum.findImpl(this.getNativeResourceHandle(), n, bl);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(int n) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.setValueImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, int n2) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFEnum.set1ValueImpl(this.getNativeResourceHandle(), n, n2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

