/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class SoMFInt32
extends SoMField {
    private static native int[] getValuesImpl(long var0, int var2);

    private static native int findImpl(long var0, int var2, boolean var3);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void set1ValueImpl(long var0, int var2, int var3);

    private static native void setValueImpl(long var0, int var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void setValuesImpl(long var0, int var2, int var3, int[] var4);

    private static native long getValueSizeImpl(long var0);

    private static native int getValueAtImpl(long var0, int var2);

    private static native long ctorImpl();

    private static native void disableDeleteValuesImpl(long var0);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFInt32.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native Object startEditingImpl(long var0);

    private static native void finishEditingImpl(long var0);

    protected SoMFInt32(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoMFInt32() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFInt32.ctorImplSync());
    }

    public int find(int n) {
        return this.find(n, false);
    }

    @Deprecated
    public int get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = this.getValueAt(n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public IntBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFInt32.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asIntBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFInt32) {
            SoMFInt32 soMFInt32 = (SoMFInt32)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFInt32.equalsImpl(this.getNativeResourceHandle(), soMFInt32.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void setValue(int n) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt32.setValueImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt32.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFInt32(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFInt32.ctorImplSync());
        SoMFInt32.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt32.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, int n2) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt32.set1ValueImpl(this.getNativeResourceHandle(), n, n2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFInt32.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int[] nArray) {
        int n2 = nArray != null ? nArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt32.setValuesImpl(this.getNativeResourceHandle(), n, n2, nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt32.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public IntBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFInt32.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asIntBuffer();
    }

    public int getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoMFInt32.getValueAtImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(int n, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoMFInt32.findImpl(this.getNativeResourceHandle(), n, bl);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            int[] nArray = SoMFInt32.getValuesImpl(this.getNativeResourceHandle(), n);
            return nArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

