/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

public class SoMFInt64
extends SoMField {
    private static native long[] getValuesImpl(long var0, int var2);

    private static native int findImpl(long var0, long var2, boolean var4);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void set1ValueImpl(long var0, int var2, long var3);

    private static native void setValueImpl(long var0, long var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void setValuesImpl(long var0, int var2, int var3, long[] var4);

    private static native long getValueSizeImpl(long var0);

    private static native long getValueAtImpl(long var0, int var2);

    private static native long ctorImpl();

    private static native void disableDeleteValuesImpl(long var0);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFInt64.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native Object startEditingImpl(long var0);

    private static native void finishEditingImpl(long var0);

    protected SoMFInt64(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoMFInt64() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFInt64.ctorImplSync());
    }

    public int find(long l) {
        return this.find(l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = this.getValueAt(n);
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public LongBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFInt64.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asLongBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFInt64) {
            SoMFInt64 soMFInt64 = (SoMFInt64)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFInt64.equalsImpl(this.getNativeResourceHandle(), soMFInt64.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void setValue(long l) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt64.setValueImpl(this.getNativeResourceHandle(), l);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt64.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFInt64(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFInt64.ctorImplSync());
        SoMFInt64.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt64.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, long l) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt64.set1ValueImpl(this.getNativeResourceHandle(), n, l);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFInt64.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, long[] lArray) {
        int n2 = lArray != null ? lArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt64.setValuesImpl(this.getNativeResourceHandle(), n, n2, lArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFInt64.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public LongBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFInt64.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asLongBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFInt64.getValueAtImpl(this.getNativeResourceHandle(), n);
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(long l, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFInt64.findImpl(this.getNativeResourceHandle(), l, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            long[] lArray = SoMFInt64.getValuesImpl(this.getNativeResourceHandle(), n);
            return lArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

