/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbMatrixd;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFMatrix
extends SoMField {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, SbMatrixd[] sbMatrixdArray) {
        this.onSetValues(n, n2);
        ObjectManager.globalLock.lock();
        try {
            SoMFMatrix.setValuesImpl1(this.getNativeResourceHandle(), n, n2, sbMatrixdArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getValuesImpl(long var0, int var2);

    private static native void set1ValueImpl1(long var0, int var2, double[] var3);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native void setValuesImpl1(long var0, int var2, int var3, Object[] var4);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void setValueImpl2(long var0, double[] var2);

    private static native void setValueImpl1(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl(long var0, float[] var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void disableDeleteValuesImpl(long var0);

    private static native Object startEditingImpl(long var0);

    private static native long ctorImpl();

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFMatrix.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    private static native void finishEditingImpl(long var0);

    protected SoMFMatrix(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(SbMatrix sbMatrix) {
        return this.find(sbMatrix, false);
    }

    @Deprecated
    public SbMatrix get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbMatrix sbMatrix = this.getValueAt(n);
            return sbMatrix;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public SoMFMatrix() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFMatrix.ctorImplSync());
    }

    public SoMFMatrix(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFMatrix.ctorImplSync());
        SoMFMatrix.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFMatrix) {
            SoMFMatrix soMFMatrix = (SoMFMatrix)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFMatrix.equalsImpl(this.getNativeResourceHandle(), soMFMatrix.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFMatrix.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbMatrix getValueAt(int n) {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.getValueAtImpl(this.getNativeResourceHandle(), n, sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public void set1Value(int n, SbMatrix sbMatrix) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.set1ValueImpl(this.getNativeResourceHandle(), n, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.setValueImpl1(this.getNativeResourceHandle(), f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFMatrix.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbMatrix sbMatrix) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.setValueImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbMatrix[] sbMatrixArray) {
        int n2 = sbMatrixArray != null ? sbMatrixArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbMatrixArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbMatrix[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFMatrix.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbMatrix.toArray(l, this.getNum() - n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbMatrixd[] sbMatrixdArray) {
        int n2 = sbMatrixdArray != null ? sbMatrixdArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.setValuesImpl1(this.getNativeResourceHandle(), n, n2, sbMatrixdArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFMatrix.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public void set1Value(int n, SbMatrixd sbMatrixd) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.set1ValueImpl1(this.getNativeResourceHandle(), n, sbMatrixd != null ? sbMatrixd.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbMatrix sbMatrix, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFMatrix.findImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbMatrixd sbMatrixd) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFMatrix.setValueImpl2(this.getNativeResourceHandle(), sbMatrixd != null ? sbMatrixd.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

