/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import com.openinventor.inventor.nodes.SoNode;

public class SoMFNode
extends SoMField {
    private static native boolean equalsImpl(long var0, long var2);

    private static native void removeAllNodesImpl(long var0);

    private static native void removeNodeImpl(long var0, int var2);

    private static native void removeNodeImpl1(long var0, long var2);

    private static native void replaceNodeImpl1(long var0, long var2, long var4);

    private static native void set1ValueImpl(long var0, int var2, long var3);

    private static native void replaceNodeImpl(long var0, int var2, long var3);

    private static native void setValueImpl(long var0, long var2);

    private static native long getNodeImpl(long var0, int var2);

    private static native void addNodeImpl(long var0, long var2);

    private static native void insertNodeImpl(long var0, long var2, int var4);

    private static native void disableDeleteValuesImpl(long var0);

    private static native int getNumNodesImpl(long var0);

    private static native long getValueSizeImpl(long var0);

    private static native int findNodeImpl(long var0, long var2);

    private static native long getValueAtImpl(long var0, int var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFNode.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native void setValuesImpl(long var0, int var2, int var3, long[] var4);

    private static native int findImpl(long var0, long var2, boolean var4);

    @Override
    protected void internalDispose() {
        int n = this.getNum();
        if (n > 0) {
            int n2;
            SoNode[] soNodeArray = new SoNode[n];
            for (n2 = 0; n2 < n; ++n2) {
                soNodeArray[n2] = this.getValueAt(n2);
            }
            this.deleteValues(0, n);
            for (n2 = 0; n2 < n; ++n2) {
                if (soNodeArray[n2] == null || !soNodeArray[n2].isDisposable()) continue;
                soNodeArray[n2].dispose();
            }
        }
        super.internalDispose();
    }

    protected SoMFNode(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoNode get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = this.getValueAt(n);
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int find(SoNode soNode) {
        return this.find(soNode, false);
    }

    @Deprecated
    public SoMFNode() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFNode.ctorImplSync());
    }

    public int findNode(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFNode.findNodeImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoMFNode.getValueAtImpl(this.getNativeResourceHandle(), n));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFNode(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFNode.ctorImplSync());
        SoMFNode.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SoNode[] soNodeArray) {
        int n2 = soNodeArray != null ? soNodeArray.length : 0;
        this.onSetValues(n, n2);
        long[] lArray = null;
        if (soNodeArray != null) {
            lArray = new long[soNodeArray.length];
            for (int i = 0; i < soNodeArray.length; ++i) {
                lArray[i] = soNodeArray[i] != null ? soNodeArray[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.setValuesImpl(this.getNativeResourceHandle(), n, n2, lArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SoNode soNode, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFNode.findImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumNodes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFNode.getNumNodesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeNode(SoNode soNode) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.removeNodeImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeNode(int n) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.removeNodeImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getNode(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoMFNode.getNodeImpl(this.getNativeResourceHandle(), n));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void insertNode(SoNode soNode, int n) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.insertNodeImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFNode.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SoNode soNode) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.setValueImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addNode(SoNode soNode) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.addNodeImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SoNode soNode) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.set1ValueImpl(this.getNativeResourceHandle(), n, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFNode) {
            SoMFNode soMFNode = (SoMFNode)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFNode.equalsImpl(this.getNativeResourceHandle(), soMFNode.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void removeAllNodes() {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.removeAllNodesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void replaceNode(SoNode soNode, SoNode soNode2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.replaceNodeImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void replaceNode(int n, SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFNode.replaceNodeImpl(this.getNativeResourceHandle(), n, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

