/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;

public class SoMFPath
extends SoMField {
    private static native int findImpl(long var0, long var2, boolean var4);

    private static native long getValueAtImpl(long var0, int var2);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl(long var0, long var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValuesImpl(long var0, int var2, int var3, long[] var4);

    private static native void set1ValueImpl(long var0, int var2, long var3);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFPath.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    protected void internalDispose() {
        int n = this.getNum();
        if (n > 0) {
            int n2;
            SoPath[] soPathArray = new SoPath[n];
            for (n2 = 0; n2 < n; ++n2) {
                soPathArray[n2] = this.getValueAt(n2);
            }
            this.deleteValues(0, n);
            for (n2 = 0; n2 < n; ++n2) {
                if (soPathArray[n2] == null || !soPathArray[n2].isDisposable()) continue;
                soPathArray[n2].dispose();
            }
        }
        super.internalDispose();
    }

    protected SoMFPath(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoMFPath() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFPath.ctorImplSync());
    }

    public int find(SoPath soPath) {
        return this.find(soPath, false);
    }

    @Deprecated
    public SoPath get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = this.getValueAt(n);
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SoPath soPath) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPath.setValueImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SoPath soPath) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPath.set1ValueImpl(this.getNativeResourceHandle(), n, soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFPath) {
            SoMFPath soMFPath = (SoMFPath)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFPath.equalsImpl(this.getNativeResourceHandle(), soMFPath.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPath.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFPath(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFPath.ctorImplSync());
        SoMFPath.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public SoPath getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoMFPath.getValueAtImpl(this.getNativeResourceHandle(), n));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SoPath soPath, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFPath.findImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFPath.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SoPath[] soPathArray) {
        int n2 = soPathArray != null ? soPathArray.length : 0;
        this.onSetValues(n, n2);
        long[] lArray = null;
        if (soPathArray != null) {
            lArray = new long[soPathArray.length];
            for (int i = 0; i < soPathArray.length; ++i) {
                lArray[i] = soPathArray[i] != null ? soPathArray[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPath.setValuesImpl(this.getNativeResourceHandle(), n, n2, lArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

