/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFPlane
extends SoMField {
    private static native long getValuesImpl(long var0, int var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    private static native long getValueSizeImpl(long var0);

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void setValueImpl(long var0, float[] var2);

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native void disableDeleteValuesImpl(long var0);

    private static native long ctorImpl();

    private static native boolean equalsImpl(long var0, long var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFPlane.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void finishEditingImpl(long var0);

    private static native Object startEditingImpl(long var0);

    protected SoMFPlane(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(SbPlane sbPlane) {
        return this.find(sbPlane, false);
    }

    @Deprecated
    public SoMFPlane() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFPlane.ctorImplSync());
    }

    @Deprecated
    public SbPlane get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbPlane sbPlane = this.getValueAt(n);
            return sbPlane;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFPlane.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    public SoMFPlane(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFPlane.ctorImplSync());
        SoMFPlane.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFPlane) {
            SoMFPlane soMFPlane = (SoMFPlane)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFPlane.equalsImpl(this.getNativeResourceHandle(), soMFPlane.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void set1Value(int n, SbPlane sbPlane) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPlane.set1ValueImpl(this.getNativeResourceHandle(), n, sbPlane != null ? sbPlane.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbPlane sbPlane) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPlane.setValueImpl(this.getNativeResourceHandle(), sbPlane != null ? sbPlane.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPlane.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbPlane sbPlane, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFPlane.findImpl(this.getNativeResourceHandle(), sbPlane != null ? sbPlane.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFPlane.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbPlane[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFPlane.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbPlane.toArray(l, this.getNum() - n);
    }

    public SbPlane getValueAt(int n) {
        SbPlane sbPlane = new SbPlane();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPlane.getValueAtImpl(this.getNativeResourceHandle(), n, sbPlane.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbPlane;
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPlane.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbPlane[] sbPlaneArray) {
        int n2 = sbPlaneArray != null ? sbPlaneArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFPlane.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbPlaneArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFPlane.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }
}

