/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbRotationd;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFRotation
extends SoMField {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, float[] fArray) {
        this.onSetValues(n, n2);
        if (fArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        if (4 * n2 > fArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        ObjectManager.globalLock.lock();
        try {
            SoMFRotation.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, SbRotationd[] sbRotationdArray) {
        this.onSetValues(n, n2);
        ObjectManager.globalLock.lock();
        try {
            SoMFRotation.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbRotationdArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setValuesImpl2(long var0, int var2, int var3, Object[] var4);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValueImpl4(long var0, double[] var2);

    private static native void set1ValueImpl1(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native void setValueImpl(long var0, float[] var2);

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void set1ValueImpl4(long var0, int var2, double[] var3);

    private static native void set1ValueImpl3(long var0, int var2, float[] var3, float var4);

    private static native void setValueImpl1(long var0, float var2, float var3, float var4, float var5);

    private static native void set1ValueImpl2(long var0, int var2, float[] var3);

    private static native void setValuesImpl1(long var0, int var2, int var3, float[] var4);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl3(long var0, float[] var2, float var3);

    private static native void setValueImpl2(long var0, float[] var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFRotation.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native Object startEditingImpl(long var0);

    private static native void finishEditingImpl(long var0);

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native long getValuesImpl(long var0, int var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    protected SoMFRotation(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoMFRotation() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFRotation.ctorImplSync());
    }

    public int find(SbRotation sbRotation) {
        return this.find(sbRotation, false);
    }

    @Deprecated
    public SbRotation get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbRotation sbRotation = this.getValueAt(n);
            return sbRotation;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFRotation.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public SbRotation getValueAt(int n) {
        SbRotation sbRotation = new SbRotation();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.getValueAtImpl(this.getNativeResourceHandle(), n, sbRotation.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbRotation[] sbRotationArray) {
        int n2 = sbRotationArray != null ? sbRotationArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbRotationArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbRotation sbRotation, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFRotation.findImpl(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbRotation[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFRotation.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbRotation.toArray(l, this.getNum() - n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float f, float f2, float f3, float f4) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.set1ValueImpl1(this.getNativeResourceHandle(), n, f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFRotation(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFRotation.ctorImplSync());
        SoMFRotation.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public void set1Value(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.set1ValueImpl2(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, SbVec3f sbVec3f, float f) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.set1ValueImpl3(this.getNativeResourceHandle(), n, sbVec3f != null ? sbVec3f.array : null, f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFRotation.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    public void set1Value(int n, SbRotation sbRotation) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.set1ValueImpl(this.getNativeResourceHandle(), n, sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbRotationd sbRotationd) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.set1ValueImpl4(this.getNativeResourceHandle(), n, sbRotationd != null ? sbRotationd.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValueImpl2(this.getNativeResourceHandle(), fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbRotationd sbRotationd) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValueImpl4(this.getNativeResourceHandle(), sbRotationd != null ? sbRotationd.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec3f sbVec3f, float f) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValueImpl3(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFRotation.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFRotation) {
            SoMFRotation soMFRotation = (SoMFRotation)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFRotation.equalsImpl(this.getNativeResourceHandle(), soMFRotation.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, float[] fArray) {
        int n2 = fArray != null ? fArray.length / 4 : 0;
        this.onSetValues(n, n2);
        if (fArray != null && fArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbRotation sbRotation) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValueImpl(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbRotationd[] sbRotationdArray) {
        int n2 = sbRotationdArray != null ? sbRotationdArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbRotationdArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(float f, float f2, float f3, float f4) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFRotation.setValueImpl1(this.getNativeResourceHandle(), f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

