/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SoMFUByte
extends SoMField {
    private static native int findImpl(long var0, byte var2, boolean var3);

    private static native byte[] getValuesImpl(long var0, int var2);

    private static native void setValuesImpl(long var0, int var2, int var3, byte[] var4);

    private static native void setValueImpl(long var0, byte var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native long getValueSizeImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void set1ValueImpl(long var0, int var2, byte var3);

    private static native byte getValueAtImpl(long var0, int var2);

    private static native long ctorImpl();

    private static native void disableDeleteValuesImpl(long var0);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFUByte.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoMFUByte(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoMFUByte() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFUByte.ctorImplSync());
    }

    @Deprecated
    public byte get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            byte by = this.getValueAt(n);
            return by;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int find(byte by) {
        return this.find(by, false);
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFUByte.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFUByte(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFUByte.ctorImplSync());
        SoMFUByte.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUByte.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFUByte) {
            SoMFUByte soMFUByte = (SoMFUByte)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFUByte.equalsImpl(this.getNativeResourceHandle(), soMFUByte.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, byte[] byArray) {
        int n2 = byArray != null ? byArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUByte.setValuesImpl(this.getNativeResourceHandle(), n, n2, byArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(byte by, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFUByte.findImpl(this.getNativeResourceHandle(), by, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, byte by) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUByte.set1ValueImpl(this.getNativeResourceHandle(), n, by);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUByte.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(byte by) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUByte.setValueImpl(this.getNativeResourceHandle(), by);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public byte[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            byte[] byArray = SoMFUByte.getValuesImpl(this.getNativeResourceHandle(), n);
            return byArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public byte getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            byte by = SoMFUByte.getValueAtImpl(this.getNativeResourceHandle(), n);
            return by;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

