/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SoMFUShort
extends SoMField {
    private static native void setValuesImpl(long var0, int var2, int var3, short[] var4);

    private static native long getValueSizeImpl(long var0);

    private static native short[] getValuesImpl(long var0, int var2);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void set1ValueImpl(long var0, int var2, short var3);

    private static native void setValueImpl(long var0, short var2);

    private static native short getValueAtImpl(long var0, int var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFUShort.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native int findImpl(long var0, short var2, boolean var3);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    protected SoMFUShort(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoMFUShort() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFUShort.ctorImplSync());
    }

    public int find(short s) {
        return this.find(s, false);
    }

    @Deprecated
    public short get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            short s = this.getValueAt(n);
            return s;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public short getValueAt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            short s = SoMFUShort.getValueAtImpl(this.getNativeResourceHandle(), n);
            return s;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUShort.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFUShort(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFUShort.ctorImplSync());
        SoMFUShort.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFUShort) {
            SoMFUShort soMFUShort = (SoMFUShort)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFUShort.equalsImpl(this.getNativeResourceHandle(), soMFUShort.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void setValue(short s) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUShort.setValueImpl(this.getNativeResourceHandle(), s);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFUShort.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUShort.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(short s, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFUShort.findImpl(this.getNativeResourceHandle(), s, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public short[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            short[] sArray = SoMFUShort.getValuesImpl(this.getNativeResourceHandle(), n);
            return sArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, short s) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUShort.set1ValueImpl(this.getNativeResourceHandle(), n, s);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, short[] sArray) {
        int n2 = sArray != null ? sArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFUShort.setValuesImpl(this.getNativeResourceHandle(), n, n2, sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

