/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3s;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class SoMFVec3s
extends SoMField {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, short[] sArray) {
        this.onSetValues(n, n2);
        if (sArray.length % 3 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 3");
        }
        if (3 * n2 > sArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        ObjectManager.globalLock.lock();
        try {
            SoMFVec3s.setValuesImpl1(this.getNativeResourceHandle(), n, n2, sArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, SbVec3f[] sbVec3fArray) {
        this.onSetValues(n, n2);
        ObjectManager.globalLock.lock();
        try {
            SoMFVec3s.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec3fArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native int findImpl(long var0, short[] var2, boolean var3);

    private static native long getValuesImpl(long var0, int var2);

    private static native long getValueSizeImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void set1ValueImpl(long var0, int var2, short[] var3);

    private static native void setValueImpl(long var0, short[] var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFVec3s.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void set1ValueImpl1(long var0, int var2, short var3, short var4, short var5);

    private static native void setValueImpl2(long var0, short[] var2);

    private static native void setValueImpl1(long var0, short var2, short var3, short var4);

    private static native void set1ValueImpl2(long var0, int var2, short[] var3);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native void setValueImpl3(long var0, float[] var2);

    private static native void getValueAtImpl(long var0, int var2, short[] var3);

    private static native void setValuesImpl2(long var0, int var2, int var3, Object[] var4);

    private static native void setValuesImpl1(long var0, int var2, int var3, short[] var4);

    private static native Object startEditingImpl(long var0);

    private static native void set1ValueImpl3(long var0, int var2, float[] var3);

    private static native void finishEditingImpl(long var0);

    protected SoMFVec3s(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(SbVec3s sbVec3s) {
        return this.find(sbVec3s, false);
    }

    @Deprecated
    public SoMFVec3s() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec3s.ctorImplSync());
    }

    @Deprecated
    public SbVec3s get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbVec3s sbVec3s = this.getValueAt(n);
            return sbVec3s;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ShortBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFVec3s.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asShortBuffer();
    }

    public SbVec3s getValueAt(int n) {
        SbVec3s sbVec3s = new SbVec3s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.getValueAtImpl(this.getNativeResourceHandle(), n, sbVec3s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3s[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFVec3s.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbVec3s.toArray(l, this.getNum() - n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbVec3s[] sbVec3sArray) {
        int n2 = sbVec3sArray != null ? sbVec3sArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbVec3sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbVec3s sbVec3s, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFVec3s.findImpl(this.getNativeResourceHandle(), sbVec3s != null ? sbVec3s.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, short[] sArray) {
        this.onSet1Value(n);
        if (sArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.set1ValueImpl2(this.getNativeResourceHandle(), n, sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFVec3s(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec3s.ctorImplSync());
        SoMFVec3s.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(short s, short s2, short s3) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValueImpl1(this.getNativeResourceHandle(), s, s2, s3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(short[] sArray) {
        this.onSetValue();
        if (sArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValueImpl2(this.getNativeResourceHandle(), sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ShortBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFVec3s.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asShortBuffer();
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFVec3s.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, short[] sArray) {
        int n2 = sArray != null ? sArray.length / 3 : 0;
        this.onSetValues(n, n2);
        if (sArray != null && sArray.length % 3 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 3");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValuesImpl1(this.getNativeResourceHandle(), n, n2, sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbVec3f[] sbVec3fArray) {
        int n2 = sbVec3fArray != null ? sbVec3fArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec3fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec3f sbVec3f) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.set1ValueImpl3(this.getNativeResourceHandle(), n, sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec3s sbVec3s) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValueImpl(this.getNativeResourceHandle(), sbVec3s != null ? sbVec3s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec3s sbVec3s) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.set1ValueImpl(this.getNativeResourceHandle(), n, sbVec3s != null ? sbVec3s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec3f sbVec3f) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.setValueImpl3(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, short s, short s2, short s3) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec3s.set1ValueImpl1(this.getNativeResourceHandle(), n, s, s2, s3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFVec3s) {
            SoMFVec3s soMFVec3s = (SoMFVec3s)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFVec3s.equalsImpl(this.getNativeResourceHandle(), soMFVec3s.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }
}

