/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec4d;
import com.openinventor.inventor.SbVec4f;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFVec4f
extends SoMField {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, float[] fArray) {
        this.onSetValues(n, n2);
        if (fArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        if (4 * n2 > fArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        ObjectManager.globalLock.lock();
        try {
            SoMFVec4f.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, SbVec4d[] sbVec4dArray) {
        this.onSetValues(n, n2);
        ObjectManager.globalLock.lock();
        try {
            SoMFVec4f.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec4dArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native long getValuesImpl(long var0, int var2);

    private static native long getValueSizeImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void setValueImpl(long var0, float[] var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFVec4f.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void set1ValueImpl1(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native void setValueImpl2(long var0, float[] var2);

    private static native void setValueImpl1(long var0, float var2, float var3, float var4, float var5);

    private static native void set1ValueImpl2(long var0, int var2, float[] var3);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native void setValueImpl3(long var0, double[] var2);

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    private static native void setValuesImpl2(long var0, int var2, int var3, Object[] var4);

    private static native void setValuesImpl1(long var0, int var2, int var3, float[] var4);

    private static native Object startEditingImpl(long var0);

    private static native void set1ValueImpl3(long var0, int var2, double[] var3);

    private static native void finishEditingImpl(long var0);

    protected SoMFVec4f(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(SbVec4f sbVec4f) {
        return this.find(sbVec4f, false);
    }

    @Deprecated
    public SoMFVec4f() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec4f.ctorImplSync());
    }

    @Deprecated
    public SbVec4f get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbVec4f sbVec4f = this.getValueAt(n);
            return sbVec4f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFVec4f.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public SbVec4f getValueAt(int n) {
        SbVec4f sbVec4f = new SbVec4f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.getValueAtImpl(this.getNativeResourceHandle(), n, sbVec4f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec4f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec4f[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFVec4f.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbVec4f.toArray(l, this.getNum() - n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbVec4f[] sbVec4fArray) {
        int n2 = sbVec4fArray != null ? sbVec4fArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbVec4fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbVec4f sbVec4f, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFVec4f.findImpl(this.getNativeResourceHandle(), sbVec4f != null ? sbVec4f.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.set1ValueImpl2(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFVec4f(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec4f.ctorImplSync());
        SoMFVec4f.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(float f, float f2, float f3, float f4) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValueImpl1(this.getNativeResourceHandle(), f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValueImpl2(this.getNativeResourceHandle(), fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFVec4f.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFVec4f.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, float[] fArray) {
        int n2 = fArray != null ? fArray.length / 4 : 0;
        this.onSetValues(n, n2);
        if (fArray != null && fArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbVec4d[] sbVec4dArray) {
        int n2 = sbVec4dArray != null ? sbVec4dArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec4dArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec4d sbVec4d) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.set1ValueImpl3(this.getNativeResourceHandle(), n, sbVec4d != null ? sbVec4d.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec4f sbVec4f) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValueImpl(this.getNativeResourceHandle(), sbVec4f != null ? sbVec4f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec4f sbVec4f) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.set1ValueImpl(this.getNativeResourceHandle(), n, sbVec4f != null ? sbVec4f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec4d sbVec4d) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.setValueImpl3(this.getNativeResourceHandle(), sbVec4d != null ? sbVec4d.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float f, float f2, float f3, float f4) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4f.set1ValueImpl1(this.getNativeResourceHandle(), n, f, f2, f3, f4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFVec4f) {
            SoMFVec4f soMFVec4f = (SoMFVec4f)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFVec4f.equalsImpl(this.getNativeResourceHandle(), soMFVec4f.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }
}

