/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec4f;
import com.openinventor.inventor.SbVec4us;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class SoMFVec4us
extends SoMField {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, short[] sArray) {
        this.onSetValues(n, n2);
        if (sArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        if (4 * n2 > sArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        ObjectManager.globalLock.lock();
        try {
            SoMFVec4us.setValuesImpl1(this.getNativeResourceHandle(), n, n2, sArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, int n2, SbVec4f[] sbVec4fArray) {
        this.onSetValues(n, n2);
        ObjectManager.globalLock.lock();
        try {
            SoMFVec4us.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec4fArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native int findImpl(long var0, short[] var2, boolean var3);

    private static native long getValuesImpl(long var0, int var2);

    private static native long getValueSizeImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void set1ValueImpl(long var0, int var2, short[] var3);

    private static native void setValueImpl(long var0, short[] var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMFVec4us.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void set1ValueImpl1(long var0, int var2, short var3, short var4, short var5, short var6);

    private static native void setValueImpl2(long var0, short[] var2);

    private static native void setValueImpl1(long var0, short var2, short var3, short var4, short var5);

    private static native void set1ValueImpl2(long var0, int var2, short[] var3);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native void setValueImpl3(long var0, float[] var2);

    private static native void getValueAtImpl(long var0, int var2, short[] var3);

    private static native void setValuesImpl2(long var0, int var2, int var3, Object[] var4);

    private static native void setValuesImpl1(long var0, int var2, int var3, short[] var4);

    private static native Object startEditingImpl(long var0);

    private static native void set1ValueImpl3(long var0, int var2, float[] var3);

    private static native void finishEditingImpl(long var0);

    protected SoMFVec4us(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(SbVec4us sbVec4us) {
        return this.find(sbVec4us, false);
    }

    @Deprecated
    public SoMFVec4us() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec4us.ctorImplSync());
    }

    @Deprecated
    public SbVec4us get1Value(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbVec4us sbVec4us = this.getValueAt(n);
            return sbVec4us;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ShortBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFVec4us.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asShortBuffer();
    }

    public SbVec4us getValueAt(int n) {
        SbVec4us sbVec4us = new SbVec4us();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.getValueAtImpl(this.getNativeResourceHandle(), n, sbVec4us.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec4us;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec4us[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range [0," + this.getNum() + "[");
        }
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoMFVec4us.getValuesImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbVec4us.toArray(l, this.getNum() - n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbVec4us[] sbVec4usArray) {
        int n2 = sbVec4usArray != null ? sbVec4usArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbVec4usArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int find(SbVec4us sbVec4us, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMFVec4us.findImpl(this.getNativeResourceHandle(), sbVec4us != null ? sbVec4us.array : null, bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, short[] sArray) {
        this.onSet1Value(n);
        if (sArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.set1ValueImpl2(this.getNativeResourceHandle(), n, sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMFVec4us(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec4us.ctorImplSync());
        SoMFVec4us.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(short s, short s2, short s3, short s4) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValueImpl1(this.getNativeResourceHandle(), s, s2, s3, s4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(short[] sArray) {
        this.onSetValue();
        if (sArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValueImpl2(this.getNativeResourceHandle(), sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void finishEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.finishEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ShortBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoMFVec4us.startEditingImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asShortBuffer();
    }

    @Override
    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMFVec4us.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, short[] sArray) {
        int n2 = sArray != null ? sArray.length / 4 : 0;
        this.onSetValues(n, n2);
        if (sArray != null && sArray.length % 4 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 4");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValuesImpl1(this.getNativeResourceHandle(), n, n2, sArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disableDeleteValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.disableDeleteValuesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(int n, SbVec4f[] sbVec4fArray) {
        int n2 = sbVec4fArray != null ? sbVec4fArray.length : 0;
        this.onSetValues(n, n2);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec4fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec4f sbVec4f) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.set1ValueImpl3(this.getNativeResourceHandle(), n, sbVec4f != null ? sbVec4f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec4us sbVec4us) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValueImpl(this.getNativeResourceHandle(), sbVec4us != null ? sbVec4us.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void set1Value(int n, SbVec4us sbVec4us) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.set1ValueImpl(this.getNativeResourceHandle(), n, sbVec4us != null ? sbVec4us.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(SbVec4f sbVec4f) {
        this.onSetValue();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.setValueImpl3(this.getNativeResourceHandle(), sbVec4f != null ? sbVec4f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, short s, short s2, short s3, short s4) {
        this.onSet1Value(n);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMFVec4us.set1ValueImpl1(this.getNativeResourceHandle(), n, s, s2, s3, s4);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFVec4us) {
            SoMFVec4us soMFVec4us = (SoMFVec4us)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoMFVec4us.equalsImpl(this.getNativeResourceHandle(), soMFVec4us.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }
}

