/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbDataType;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SoSFArray
extends SoSField {
    @Deprecated
    public static final int COPY = CopyPolicies.access$000();
    @Deprecated
    public static final int NO_COPY = CopyPolicies.access$100();
    @Deprecated
    public static final int UNSIGNED_BYTE = DataTypes.access$200();
    @Deprecated
    public static final int UNSIGNED_SHORT = DataTypes.access$300();
    @Deprecated
    public static final int UNSIGNED_INT32 = DataTypes.access$400();
    @Deprecated
    public static final int SIGNED_BYTE = DataTypes.access$500();
    @Deprecated
    public static final int SIGNED_SHORT = DataTypes.access$600();
    @Deprecated
    public static final int SIGNED_INT32 = DataTypes.access$700();
    @Deprecated
    public static final int FLOAT = DataTypes.access$800();
    private ByteBuffer m_data_setValue;

    private static native boolean isEmptyImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native int getDataTypeImpl(long var0);

    private static native void setValueImpl(long var0, int[] var2, long var3, Object var5, int var6);

    private static native boolean isNeverWriteImpl(long var0);

    private static native void getSizeImpl(long var0, int[] var2);

    private static native Object getValueImpl(long var0, int[] var2, long var3);

    private static native void setNeverWriteImpl(long var0, boolean var2);

    private static native long getValueSizeImpl(long var0);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSFArray.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native Object getDataImpl(long var0);

    protected SoSFArray(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void setValue(SbVec3i32 sbVec3i32, SbDataType sbDataType, ByteBuffer byteBuffer) {
        this.setValue(sbVec3i32, sbDataType, byteBuffer, CopyPolicies.valueOf(CopyPolicies.COPY.getValue()));
    }

    @Deprecated
    public SoSFArray() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFArray.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array3D getValue() {
        Array3D array3D = new Array3D();
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        SbDataType sbDataType = new SbDataType();
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoSFArray.getValueImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbDataType != null ? sbDataType.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        array3D.buffer = byteBuffer.asReadOnlyBuffer();
        array3D.size = sbVec3i32;
        array3D.dataType = sbDataType;
        return array3D;
    }

    public SoSFArray(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFArray.ctorImplSync());
        SoSFArray.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public boolean isNeverWrite() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSFArray.isNeverWriteImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3i32 getSize() {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFArray.getSizeImpl(this.getNativeResourceHandle(), sbVec3i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3i32;
    }

    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoSFArray.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setNeverWrite(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFArray.setNeverWriteImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(SbVec3i32 sbVec3i32, SbDataType sbDataType, ByteBuffer byteBuffer, CopyPolicies copyPolicies) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.m_data_setValue = byteBuffer;
        if (copyPolicies == CopyPolicies.NO_COPY) {
            this.m_data_setValue = byteBuffer;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFArray.setValueImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbDataType != null ? sbDataType.getNativeResourceHandle() : Inventor.ZeroHandle, byteBuffer, copyPolicies.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isEmpty() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSFArray.isEmptyImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFArray) {
            SoSFArray soSFArray = (SoSFArray)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoSFArray.equalsImpl(this.getNativeResourceHandle(), soSFArray.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public ByteBuffer getData() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoSFArray.getDataImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public DataTypes getDataType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            DataTypes dataTypes = IntegerValuedEnumHelper.fromIntValue(DataTypes.class, SoSFArray.getDataTypeImpl(this.getNativeResourceHandle()));
            return dataTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static class Array3D {
        public SbVec3i32 size;
        public SbDataType dataType;
        public ByteBuffer buffer;
    }

    public static enum DataTypes implements IntegerValuedEnum
    {
        UNSIGNED_BYTE(DataTypes.getUNSIGNEDBYTE()),
        UNSIGNED_SHORT(DataTypes.getUNSIGNEDSHORT()),
        UNSIGNED_INT32(DataTypes.getUNSIGNEDINT32()),
        SIGNED_BYTE(DataTypes.getSIGNEDBYTE()),
        SIGNED_SHORT(DataTypes.getSIGNEDSHORT()),
        SIGNED_INT32(DataTypes.getSIGNEDINT32()),
        FLOAT(DataTypes.getFLOAT());

        private int value;

        private static native int getSIGNEDINT32();

        private static native int getSIGNEDSHORT();

        private DataTypes(int n2) {
            this.value = n2;
        }

        private static native int getFLOAT();

        private static native int getUNSIGNEDSHORT();

        private static native int getUNSIGNEDBYTE();

        private static native int getSIGNEDBYTE();

        private static native int getUNSIGNEDINT32();

        @Deprecated
        public static DataTypes fromValue(int n) {
            return DataTypes.valueOf(n);
        }

        public static DataTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DataTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$200() {
            return DataTypes.getUNSIGNEDBYTE();
        }

        static /* synthetic */ int access$300() {
            return DataTypes.getUNSIGNEDSHORT();
        }

        static /* synthetic */ int access$400() {
            return DataTypes.getUNSIGNEDINT32();
        }

        static /* synthetic */ int access$500() {
            return DataTypes.getSIGNEDBYTE();
        }

        static /* synthetic */ int access$600() {
            return DataTypes.getSIGNEDSHORT();
        }

        static /* synthetic */ int access$700() {
            return DataTypes.getSIGNEDINT32();
        }

        static /* synthetic */ int access$800() {
            return DataTypes.getFLOAT();
        }
    }

    public static enum CopyPolicies implements IntegerValuedEnum
    {
        COPY(CopyPolicies.getCOPY()),
        NO_COPY(CopyPolicies.getNOCOPY());

        private int value;

        private CopyPolicies(int n2) {
            this.value = n2;
        }

        private static native int getNOCOPY();

        private static native int getCOPY();

        @Deprecated
        public static CopyPolicies fromValue(int n) {
            return CopyPolicies.valueOf(n);
        }

        public static CopyPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CopyPolicies.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return CopyPolicies.getCOPY();
        }

        static /* synthetic */ int access$100() {
            return CopyPolicies.getNOCOPY();
        }
    }
}

