/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;

public class SoSFDouble
extends SoSField {
    private static native double getValueImpl(long var0);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl(long var0, double var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSFDouble.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5, double var6);

    protected SoSFDouble(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoSFDouble() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFDouble.ctorImplSync());
    }

    public void setValue(double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFDouble.setValueImpl(this.getNativeResourceHandle(), d);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFDouble) {
            SoSFDouble soSFDouble = (SoSFDouble)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoSFDouble.equalsImpl(this.getNativeResourceHandle(), soSFDouble.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public double getValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            double d = SoSFDouble.getValueImpl(this.getNativeResourceHandle());
            return d;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSFDouble(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, double d) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFDouble.ctorImplSync());
        SoSFDouble.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue(), d);
    }

    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoSFDouble.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

