/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.engines.SoEngine;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;

public class SoSFEngine
extends SoSField {
    private static native long getValueImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5, long var6);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSFEngine.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    protected void internalDispose() {
        SoEngine soEngine = this.getValue();
        this.setValue(null);
        if (null != soEngine && soEngine.isDisposable()) {
            soEngine.dispose();
        }
        super.internalDispose();
    }

    protected SoSFEngine(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoSFEngine() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFEngine.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFEngine) {
            SoSFEngine soSFEngine = (SoSFEngine)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoSFEngine.equalsImpl(this.getNativeResourceHandle(), soSFEngine.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoSFEngine.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoEngine getValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEngine soEngine = ObjectManager.getManagedObjectFor(SoEngine.class, SoSFEngine.getValueImpl(this.getNativeResourceHandle()));
            return soEngine;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSFEngine(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, SoEngine soEngine) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFEngine.ctorImplSync());
        SoSFEngine.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue(), soEngine != null ? soEngine.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void setValue(SoEngine soEngine) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFEngine.setValueImpl(this.getNativeResourceHandle(), soEngine != null ? soEngine.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

