/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.SingleMemberClassAnnotation;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;
import com.openinventor.inventor.nodes.SoNode;

public class SoSFEnum<EnumType extends Enum<EnumType>>
extends SoSField {
    protected Class<EnumType> m_enumTypeClass;

    protected SoSFEnum(Inventor.ConstructorCommand constructorCommand, long l, Class<EnumType> clazz) {
        super(constructorCommand, l);
        this.initializeFields();
        this.m_enumTypeClass = clazz;
    }

    public EnumType getValue(@SingleMemberClassAnnotation(value="@sharpen.remove") Class<EnumType> clazz) {
        return IntegerValuedEnumHelper.fromIntValue(clazz, this.getValue());
    }

    public void setValue(EnumType EnumType) {
        this.setValue(((IntegerValuedEnum)EnumType).getValue());
    }

    private static native void setValueImpl(long var0, int var2);

    private static native int getValueImpl(long var0);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl1(long var0, String var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5, int var6);

    private static native void addEnumValueNative(long var0, String var2, String var3, int var4);

    private static native void setEnumTypeNative(long var0, long var2, String var4);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSFEnum.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoSFEnum(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoSFEnum() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFEnum.ctorImplSync());
    }

    public SoSFEnum(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, @SingleMemberClassAnnotation(value="@sharpen.remove") Class<EnumType> clazz, EnumType EnumType) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFEnum.ctorImplSync());
        this.m_enumTypeClass = clazz;
        SoSFEnum.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue(), ((IntegerValuedEnum)EnumType).getValue());
        String string2 = clazz.getSimpleName();
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            String string3 = enum_.toString();
            int n = ((IntegerValuedEnum)Enum.valueOf(clazz, string3)).getValue();
            SoSFEnum.addEnumValueNative(soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string2, string3, n);
        }
        if (SoNode.class.isAssignableFrom(soFieldContainer.getClass())) {
            SoSFEnum.setEnumTypeNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFEnum) {
            SoSFEnum soSFEnum = (SoSFEnum)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoSFEnum.equalsImpl(this.getNativeResourceHandle(), soSFEnum.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void setValue(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFEnum.setValueImpl1(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoSFEnum.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSFEnum.getValueImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setValue(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFEnum.setValueImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

