/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;

public class SoSFFloat
extends SoSField {
    private static native float getValueImpl(long var0);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl(long var0, float var2);

    private static native boolean equalsImpl(long var0, long var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSFFloat.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5, float var6);

    protected SoSFFloat(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoSFFloat() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFFloat.ctorImplSync());
    }

    public void setValue(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFFloat.setValueImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFFloat) {
            SoSFFloat soSFFloat = (SoSFFloat)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoSFFloat.equalsImpl(this.getNativeResourceHandle(), soSFFloat.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public float getValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoSFFloat.getValueImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSFFloat(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, float f) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFFloat.ctorImplSync());
        SoSFFloat.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue(), f);
    }

    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoSFFloat.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

