/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;
import com.openinventor.inventor.nodes.SoNode;

public class SoSFNode
extends SoSField {
    private static native long getValueImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5, long var6);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSFNode.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    protected void internalDispose() {
        SoNode soNode = this.getValue();
        this.setValue(null);
        if (null != soNode && soNode.isDisposable()) {
            soNode.dispose();
        }
        super.internalDispose();
    }

    protected SoSFNode(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoSFNode() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFNode.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFNode) {
            SoSFNode soSFNode = (SoSFNode)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoSFNode.equalsImpl(this.getNativeResourceHandle(), soSFNode.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoSFNode.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSFNode(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, SoNode soNode) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFNode.ctorImplSync());
        SoSFNode.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void setValue(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFNode.setValueImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoSFNode.getValueImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

