/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;

public class SoSFPath
extends SoSField {
    private static native long getValueImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native long getValueSizeImpl(long var0);

    private static native void setValueImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5, long var6);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSFPath.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    protected void internalDispose() {
        SoPath soPath = this.getValue();
        this.setValue(null);
        if (null != soPath && soPath.isDisposable()) {
            soPath.dispose();
        }
        super.internalDispose();
    }

    protected SoSFPath(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Deprecated
    public SoSFPath() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFPath.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFPath) {
            SoSFPath soSFPath = (SoSFPath)object;
            this.acquireLock(ObjectManager.globalLock);
            try {
                boolean bl = SoSFPath.equalsImpl(this.getNativeResourceHandle(), soSFPath.getNativeResourceHandle());
                return bl;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }
        return false;
    }

    public void setValue(SoPath soPath) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSFPath.setValueImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getValue() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoSFPath.getValueImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long getValueSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoSFPath.getValueSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSFPath(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, SoPath soPath) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFPath.ctorImplSync());
        SoSFPath.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
    }
}

