/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.helpers;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoGLContext;

public class SbGLShareContext
extends Inventor {
    public final SoGLContext shareContext;

    private static native void toArrayImpl(long var0, long[] var2);

    private static native long ctorImpl1(long var0, int var2);

    private static native void setValueImpl(long var0, long var2);

    private static native int getContextGroupIdImpl(long var0);

    private static native long getContextImpl(long var0);

    private static native long ctorImpl();

    private static native long getShareContextFieldHandle(long var0);

    protected SbGLShareContext(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.shareContext = ObjectManager.getManagedObjectFor(SoGLContext.class, SbGLShareContext.getShareContextFieldHandle(this.getNativeResourceHandle()));
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public SbGLShareContext(SbGLShareContext sbGLShareContext) {
        this();
        this.setValue(sbGLShareContext);
    }

    public SbGLShareContext(SoGLContext soGLContext, int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SbGLShareContext.ctorImpl1(soGLContext != null ? soGLContext.getNativeResourceHandle() : Inventor.ZeroHandle, n));
    }

    public static SbGLShareContext[] toArray(long l, long l2) {
        SbGLShareContext[] sbGLShareContextArray = new SbGLShareContext[(int)l2];
        long[] lArray = new long[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbGLShareContextArray[n] = new SbGLShareContext();
            lArray[n] = sbGLShareContextArray[n].getNativeResourceHandle();
            ++n;
        }
        SbGLShareContext.toArrayImpl(l, lArray);
        return sbGLShareContextArray;
    }

    public SoGLContext getContext() {
        return ObjectManager.getManagedObjectFor(SoGLContext.class, SbGLShareContext.getContextImpl(this.getNativeResourceHandle()));
    }

    public int getContextGroupId() {
        return SbGLShareContext.getContextGroupIdImpl(this.getNativeResourceHandle());
    }

    public SbGLShareContext() {
        this(Inventor.ConstructorCommand.CreateInstance, SbGLShareContext.ctorImpl());
    }

    public void setValue(SbGLShareContext sbGLShareContext) {
        SbGLShareContext.setValueImpl(this.getNativeResourceHandle(), sbGLShareContext.getNativeResourceHandle());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

