/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.helpers;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.helpers.SbGraphicsCapabilities;

public class SbGPUCapabilities
extends SbGraphicsCapabilities {
    @Deprecated
    public static final int COMPATIBILITY = Profiles.access$000();
    @Deprecated
    public static final int CORE = Profiles.access$100();
    @Deprecated
    public static final int INTEL_GPU = GpuVendors.access$200();
    @Deprecated
    public static final int AMD_GPU = GpuVendors.access$300();
    @Deprecated
    public static final int NVIDIA_GPU = GpuVendors.access$400();
    @Deprecated
    public static final int UNKNOWN_GPU = GpuVendors.access$500();

    private static native int getGpuVendorImpl(long var0);

    private static native int getMaxVertexAttribsImpl(long var0);

    private static native int getMax3DTextureSizeImpl(long var0);

    private static native int getMaxTextureSizeImpl(long var0);

    private static native String getRendererImpl(long var0);

    private static native int getVersionImpl(long var0);

    private static native void getMaxViewportSizeImpl(long var0, int[] var2);

    private static native int getProfileImpl(long var0);

    private static native int getMaxFixedPipelineTextureUnitsImpl(long var0);

    protected SbGPUCapabilities(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getMaxFixedPipelineTextureUnits() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGPUCapabilities.getMaxFixedPipelineTextureUnitsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public GpuVendors getGpuVendor() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            GpuVendors gpuVendors = IntegerValuedEnumHelper.fromIntValue(GpuVendors.class, SbGPUCapabilities.getGpuVendorImpl(this.getNativeResourceHandle()));
            return gpuVendors;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getVersion() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGPUCapabilities.getVersionImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Profiles getProfile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Profiles profiles = IntegerValuedEnumHelper.fromIntValue(Profiles.class, SbGPUCapabilities.getProfileImpl(this.getNativeResourceHandle()));
            return profiles;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2i32 getMaxViewportSize() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbGPUCapabilities.getMaxViewportSizeImpl(this.getNativeResourceHandle(), sbVec2i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2i32;
    }

    public int getMaxTextureSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGPUCapabilities.getMaxTextureSizeImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMax3DTextureSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGPUCapabilities.getMax3DTextureSizeImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxVertexAttribs() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGPUCapabilities.getMaxVertexAttribsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getRenderer() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SbGPUCapabilities.getRendererImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum GpuVendors implements IntegerValuedEnum
    {
        INTEL_GPU(GpuVendors.getINTELGPU()),
        AMD_GPU(GpuVendors.getAMDGPU()),
        NVIDIA_GPU(GpuVendors.getNVIDIAGPU()),
        UNKNOWN_GPU(GpuVendors.getUNKNOWNGPU());

        private int value;

        private static native int getUNKNOWNGPU();

        private GpuVendors(int n2) {
            this.value = n2;
        }

        private static native int getNVIDIAGPU();

        private static native int getINTELGPU();

        private static native int getAMDGPU();

        @Deprecated
        public static GpuVendors fromValue(int n) {
            return GpuVendors.valueOf(n);
        }

        public static GpuVendors valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(GpuVendors.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$200() {
            return GpuVendors.getINTELGPU();
        }

        static /* synthetic */ int access$300() {
            return GpuVendors.getAMDGPU();
        }

        static /* synthetic */ int access$400() {
            return GpuVendors.getNVIDIAGPU();
        }

        static /* synthetic */ int access$500() {
            return GpuVendors.getUNKNOWNGPU();
        }
    }

    public static enum Profiles implements IntegerValuedEnum
    {
        COMPATIBILITY(Profiles.getCOMPATIBILITY()),
        CORE(Profiles.getCORE());

        private int value;

        private Profiles(int n2) {
            this.value = n2;
        }

        private static native int getCORE();

        private static native int getCOMPATIBILITY();

        @Deprecated
        public static Profiles fromValue(int n) {
            return Profiles.valueOf(n);
        }

        public static Profiles valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Profiles.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return Profiles.getCOMPATIBILITY();
        }

        static /* synthetic */ int access$100() {
            return Profiles.getCORE();
        }
    }
}

