/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.helpers;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SbGraphicsCapabilities
extends Inventor {
    private static native int getMaxClipPlanesImpl(long var0);

    private static native int getMaxImageUnitsImpl(long var0);

    private static native int getMaxTextureCoordsImpl(long var0);

    private static native int getMaxDrawBuffersImpl(long var0);

    private static native int getMaxHardwareLightsImpl(long var0);

    private static native int getMinGLSLVersionImpl(long var0);

    private static native long ctorImpl();

    private static native int getMaxColorTargetsImpl(long var0);

    private static native int getMaxTextureUnitsImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SbGraphicsCapabilities.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SbGraphicsCapabilities(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getMinGLSLVersion() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMinGLSLVersionImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxImageUnits() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMaxImageUnitsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbGraphicsCapabilities() {
        this(Inventor.ConstructorCommand.CreateInstance, SbGraphicsCapabilities.ctorImplSync());
    }

    public int getMaxTextureUnits() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMaxTextureUnitsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxHardwareLights() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMaxHardwareLightsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxDrawBuffers() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMaxDrawBuffersImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxColorTargets() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMaxColorTargetsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxTextureCoords() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMaxTextureCoordsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxClipPlanes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbGraphicsCapabilities.getMaxClipPlanesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

