/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.image;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.image.SoRasterImageIO;
import com.openinventor.inventor.image.SoRasterImageRW;

public class SoRasterReaderSet
extends Inventor {
    private static native void deleteReadersImpl(int var0, int var1);

    private static native void addReaderImpl(long var0);

    private static native String getReaderAtImpl(int var0);

    private static native int getNumReadersImpl();

    private static native long getReaderImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoRasterReaderSet(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static void deleteReaders(int n) {
        SoRasterReaderSet.deleteReaders(n, -1);
    }

    public static int getNumReaders() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoRasterReaderSet.getNumReadersImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoRasterImageRW getReader(SoRasterImageIO soRasterImageIO) {
        ObjectManager.globalLock.lock();
        try {
            SoRasterImageRW soRasterImageRW = ObjectManager.getManagedObjectFor(SoRasterImageRW.class, SoRasterReaderSet.getReaderImpl(soRasterImageIO != null ? soRasterImageIO.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soRasterImageRW;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static Class<? extends Inventor> getReaderAt(int n) {
        ObjectManager.globalLock.lock();
        try {
            Class<? extends Inventor> clazz = NativeTypeMap.getJavaClass(SoRasterReaderSet.getReaderAtImpl(n));
            return clazz;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void deleteReaders(int n, int n2) {
        ObjectManager.globalLock.lock();
        try {
            SoRasterReaderSet.deleteReadersImpl(n, n2);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void addReader(SoRasterImageRW soRasterImageRW) {
        ObjectManager.globalLock.lock();
        try {
            SoRasterReaderSet.addReaderImpl(soRasterImageRW != null ? soRasterImageRW.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

