/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.io.stl;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoCallbackAction;
import com.openinventor.inventor.io.stl.SoSTLInputReader;

public class SoSTLWriteAction
extends SoCallbackAction {
    private static native void enableElementImpl(String var0, int var1);

    private static native boolean isBinaryOutputImpl(long var0);

    private static native void setBinaryOutputImpl(long var0, boolean var2);

    private static native void setOutputFileNameImpl(long var0, String var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSTLWriteAction.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    protected SoSTLWriteAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void setBinaryOutput(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSTLWriteAction.setBinaryOutputImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isBinaryOutput() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSTLWriteAction.isBinaryOutputImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ObjectManager.globalLock.lock();
        try {
            SoSTLWriteAction.enableElementImpl(string, n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void setOutputFileName(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSTLWriteAction.setOutputFileNameImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSTLWriteAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSTLWriteAction.ctorImplSync());
    }

    static {
        SoSTLInputReader.checkInit();
    }
}

