/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.lock;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.lock.SoLicensedProduct;

public class SoLicensesInfo
extends Inventor {
    private static native int checkImpl(String var0, float var1, String var2, boolean var3, String[] var4);

    private static native String getVersionImpl();

    private static native void getLicensedProductImpl(int var0, long var1);

    private static native float getLicensingVersionNumberImpl();

    private static native int getProductCountImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoLicensesInfo(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static int check(String string, float f) {
        return SoLicensesInfo.check(string, f, null, true, null);
    }

    public static int check(String string, float f, String string2) {
        return SoLicensesInfo.check(string, f, string2, true, null);
    }

    public static int check(String string, float f, String string2, boolean bl) {
        return SoLicensesInfo.check(string, f, string2, bl, null);
    }

    public static int getProductCount() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoLicensesInfo.getProductCountImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static float getLicensingVersionNumber() {
        ObjectManager.globalLock.lock();
        try {
            float f = SoLicensesInfo.getLicensingVersionNumberImpl();
            return f;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int check(String string, float f, String string2, boolean bl, String[] stringArray) {
        ObjectManager.globalLock.lock();
        try {
            int n = SoLicensesInfo.checkImpl(string, f, string2, bl, stringArray);
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoLicensedProduct getLicensedProduct(int n) {
        SoLicensedProduct soLicensedProduct = new SoLicensedProduct();
        ObjectManager.globalLock.lock();
        try {
            SoLicensesInfo.getLicensedProductImpl(n, soLicensedProduct.getNativeResourceHandle());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return soLicensedProduct;
    }

    public static String getVersion() {
        ObjectManager.globalLock.lock();
        try {
            String string = SoLicensesInfo.getVersionImpl();
            return string;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

