/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.lock;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.errors.SoLibraryError;
import java.awt.Button;
import java.awt.Toolkit;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SoLockManager {
    static String[] s_OivLibPath = null;
    private static final int VERBOSE_LEVEL;
    private static final boolean NATIVE_DEBUG;
    private static boolean s_loaded;

    public static boolean isNativeLoaded() {
        return s_loaded;
    }

    public static void loadLibrary(String string) {
        String string2 = System.getProperty("os.name");
        OivLibraryLoader oivLibraryLoader = string2.startsWith("Windows") ? new Win32OivLibraryLoader() : new UnixOivLibraryLoader();
        oivLibraryLoader.loadLibrary(string);
    }

    public static void setUnlockString(String string) {
        SoLockManager.setUnlockStringNativ(string);
    }

    private static native void setUnlockStringNativ(String var0);

    public static void appendUnlockString(String string) {
        SoLockManager.appendUnlockStringNativ(string);
    }

    private static native void appendUnlockStringNativ(String var0);

    @Deprecated
    public static String getUnlockString() {
        return null;
    }

    static {
        s_loaded = false;
        VERBOSE_LEVEL = SoPreferences.getInteger("OIV_JAVA_VERBOSE_LEVEL", 0);
        NATIVE_DEBUG = SoPreferences.getBoolean("OIV_JAVA_LOAD_DEBUG_NATIVE_LIBRARIES", false);
        String string = SoPreferences.getValue("OIV_LIBRARY_PATH");
        if (string != null && string.length() != 0) {
            s_OivLibPath = string.split(File.pathSeparator);
        }
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Loading Open Inventor Java Native Interface library...");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block12: {
                    String string = System.getProperty("os.name");
                    try {
                        UnixOivLibraryLoader unixOivLibraryLoader;
                        block13: {
                            if (string.startsWith("Windows")) {
                                Win32OivLibraryLoader win32OivLibraryLoader;
                                block11: {
                                    win32OivLibraryLoader = new Win32OivLibraryLoader("D");
                                    Win32OivLibraryLoader win32OivLibraryLoader2 = new Win32OivLibraryLoader("-gd");
                                    Win32OivLibraryLoader win32OivLibraryLoader3 = new Win32OivLibraryLoader("_d");
                                    Win32OivLibraryLoader win32OivLibraryLoader4 = new Win32OivLibraryLoader("_debug");
                                    win32OivLibraryLoader.loadLibrary("InventorBase");
                                    win32OivLibraryLoader.loadLibrary("InventorGL");
                                    win32OivLibraryLoader.loadLibrary("InventorImage");
                                    win32OivLibraryLoader2.loadLibrary("fei_boost_date_time-mt");
                                    win32OivLibraryLoader2.loadLibrary("fei_boost_system-mt");
                                    win32OivLibraryLoader.loadLibrary("fei_imageAccess");
                                    win32OivLibraryLoader.loadLibrary("Inventor");
                                    win32OivLibraryLoader.loadLibrary("InventorAlgorithms");
                                    win32OivLibraryLoader.loadLibrary("ScaleViz");
                                    win32OivLibraryLoader.loadLibrary("InventorGui");
                                    win32OivLibraryLoader.loadLibrary("Qt5Core");
                                    win32OivLibraryLoader.loadLibrary("Qt5Gui");
                                    win32OivLibraryLoader.loadLibrary("Qt5Widgets");
                                    win32OivLibraryLoader.loadLibrary("Qt5PrintSupport");
                                    win32OivLibraryLoader.loadLibrary("HardCopy");
                                    win32OivLibraryLoader.loadLibrary("Qt5XML");
                                    win32OivLibraryLoader.loadLibrary("IvTuneExtenderAPI");
                                    win32OivLibraryLoader.loadLibrary("Qt5OpenGL");
                                    win32OivLibraryLoader.loadLibrary("InventorQt");
                                    win32OivLibraryLoader.loadLibrary("IvTune");
                                    win32OivLibraryLoader.loadLibrary("MeshViz");
                                    win32OivLibraryLoader.loadLibrary("LDM");
                                    win32OivLibraryLoader.loadLibrary("VolumeViz");
                                    win32OivLibraryLoader2.loadLibrary("fei_proxy_boost_system-mt");
                                    win32OivLibraryLoader2.loadLibrary("fei_proxy_boost_chrono-mt");
                                    win32OivLibraryLoader2.loadLibrary("fei_proxy_boost_filesystem-mt");
                                    win32OivLibraryLoader2.loadLibrary("fei_proxy_boost_iostreams-mt");
                                    win32OivLibraryLoader2.loadLibrary("fei_proxy_boost_thread-mt");
                                    win32OivLibraryLoader2.loadLibrary("fei_proxy_boost_date_time-mt");
                                    win32OivLibraryLoader.loadLibrary("fei_proxy_tbb");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_VisilogIP");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_VlgUtil");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_ServiceHandler");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_AccessVisilib");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_Reconstruction");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_Data");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_Process");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_VisilogAPI");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_VisilogProxy");
                                    win32OivLibraryLoader2.loadLibrary("fei_boost_chrono-mt");
                                    win32OivLibraryLoader2.loadLibrary("fei_boost_thread-mt");
                                    win32OivLibraryLoader4.loadLibrary("IvTbb");
                                    win32OivLibraryLoader.loadLibrary("MeshVizExtractor");
                                    win32OivLibraryLoader.loadLibrary("ImageViz");
                                    win32OivLibraryLoader2.loadLibrary("fei_boost_random-mt");
                                    win32OivLibraryLoader.loadLibrary("RemoteVizClient");
                                    win32OivLibraryLoader.loadLibrary("DirectViz");
                                    win32OivLibraryLoader.loadLibrary("FXViz");
                                    win32OivLibraryLoader.loadLibrary("ScaleVizRemote");
                                    win32OivLibraryLoader.loadLibrary("SolidViz");
                                    win32OivLibraryLoader.loadLibrary("RemoteVizServices");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_LgSkeletonPolyg");
                                    win32OivLibraryLoader3.loadLibrary("fei_proxy_ippro51");
                                    Button button = new Button();
                                    try {
                                        if (VERBOSE_LEVEL > 0) {
                                            System.out.println("Loading jawt...");
                                        }
                                        System.loadLibrary("jawt");
                                    }
                                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                        if (unsatisfiedLinkError.getMessage().indexOf("already loaded in another classloader") >= 0) break block11;
                                        throw unsatisfiedLinkError;
                                    }
                                }
                                win32OivLibraryLoader.loadLibrary("com.openinventor.inventor");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.directviz");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.fxviz");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.hardcopy");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.ldm");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.meshviz");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.scaleviz");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.solidviz");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.volumeviz");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.remoteviz.rendering");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.remoteviz.clients");
                                win32OivLibraryLoader.loadLibrary("com.openinventor.imageviz");
                                break block12;
                            }
                            unixOivLibraryLoader = new UnixOivLibraryLoader();
                            Toolkit.getDefaultToolkit();
                            try {
                                if (VERBOSE_LEVEL > 0) {
                                    System.out.println("Loading jawt...");
                                }
                                System.loadLibrary("jawt");
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                if (unsatisfiedLinkError.getMessage().indexOf("already loaded in another classloader") >= 0) break block13;
                                throw unsatisfiedLinkError;
                            }
                        }
                        unixOivLibraryLoader.loadLibrary("com.openinventor.inventor");
                        if (!string.startsWith("Mac")) {
                            unixOivLibraryLoader.loadLibrary("com.openinventor.directviz");
                        }
                        unixOivLibraryLoader.loadLibrary("com.openinventor.fxviz");
                        unixOivLibraryLoader.loadLibrary("com.openinventor.hardcopy");
                        unixOivLibraryLoader.loadLibrary("com.openinventor.ldm");
                        unixOivLibraryLoader.loadLibrary("com.openinventor.meshviz");
                        unixOivLibraryLoader.loadLibrary("com.openinventor.scaleviz");
                        unixOivLibraryLoader.loadLibrary("com.openinventor.solidviz");
                        unixOivLibraryLoader.loadLibrary("com.openinventor.volumeviz");
                        if (!string.startsWith("Mac")) {
                            unixOivLibraryLoader.loadLibrary("com.openinventor.remoteviz.rendering");
                        }
                        unixOivLibraryLoader.loadLibrary("com.openinventor.remoteviz.clients");
                        unixOivLibraryLoader.loadLibrary("com.openinventor.imageviz");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        String string2 = System.getProperty("line.separator");
                        throw new SoLibraryError(unsatisfiedLinkError.getMessage() + string2 + "Native library of \"Open Inventor Java\" cannot be loaded." + string2 + "java.library.path = " + SoPreferences.getValue("java.library.path", "<not defined>"));
                    }
                }
                return null;
            }
        });
        s_loaded = true;
    }

    static class Win32OivLibraryLoader
    extends OivLibraryLoader {
        private final String m_suffix;
        private final String m_extension;

        Win32OivLibraryLoader() {
            this("D");
        }

        Win32OivLibraryLoader(String string) {
            this.m_extension = ".dll";
            this.m_suffix = NATIVE_DEBUG ? string : "";
        }

        @Override
        void loadLibrary(String string) {
            block7: {
                try {
                    super.loadLibrary(string + this.m_suffix);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    String string2 = unsatisfiedLinkError.getMessage();
                    boolean bl = false;
                    if (s_OivLibPath != null) {
                        String string3 = string + this.m_extension;
                        for (int i = 0; i < s_OivLibPath.length; ++i) {
                            try {
                                String string4 = s_OivLibPath[i] + File.separator + string3;
                                if (VERBOSE_LEVEL > 0) {
                                    System.out.println("Loading " + string4 + "...");
                                }
                                System.load(string4);
                                bl = true;
                                break;
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                                string2 = string2 + System.getProperty("line.separator") + unsatisfiedLinkError2.getMessage();
                                continue;
                            }
                        }
                    }
                    if (bl) break block7;
                    throw new UnsatisfiedLinkError(string2);
                }
            }
        }
    }

    static class UnixOivLibraryLoader
    extends OivLibraryLoader {
        UnixOivLibraryLoader() {
        }
    }

    static abstract class OivLibraryLoader {
        protected OivLibraryLoader() {
        }

        void loadLibrary(String string) throws UnsatisfiedLinkError {
            if (VERBOSE_LEVEL > 0) {
                System.out.println("Loading " + string + "...");
            }
            System.loadLibrary(string);
        }
    }
}

