/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.vrmlnodes.SoVRMLEXTERNPROTODef;
import com.openinventor.inventor.vrmlnodes.SoVRMLPROTODef;

public class SoBase
extends Inventor
implements SafeDisposable {
    protected void setNativeResourceHandle(long l) {
        throw new RuntimeException("Operation not implemented.");
    }

    @Deprecated
    private static SoBase newInstance(long l) {
        if (l == 0L) {
            if (VERBOSE_LEVEL > 0) {
                System.out.println("DEBUG: JAVA MTHD->SoBase.newInstance with null native address");
            }
            return null;
        }
        return ObjectManager.getManagedObjectFor(SoBase.class, l);
    }

    @Deprecated
    private static SoBase newInstance(long l, String string) {
        return SoBase.newInstance(l);
    }

    private static native boolean hasMultipleWriteRefsImpl(long var0);

    private static native long ctorImpl();

    private static native String getFileFormatNameImpl(long var0);

    private static native boolean readInstanceImpl(long var0, long var2, short var4);

    private static native int getCurrentWriteCounterImpl();

    private static native String getNameImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoBase.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setNameImpl(long var0, String var2);

    private static native void touchImpl(long var0);

    private static native void nativeDerivedClassInit();

    private static native long getPROTOImpl(String var0);

    private static native long getEXTERNPROTOImpl(String var0);

    private static native void initCustomClass(long var0, Inventor var2);

    private static native void setSynchronizableImpl(long var0, boolean var2);

    private static native boolean isSynchronizableImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    protected SoBase(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    protected SoBase(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readInstance(SoInput soInput, short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBase.readInstanceImpl(this.getNativeResourceHandle(), soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle, s);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected static int getCurrentWriteCounter() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoBase.getCurrentWriteCounterImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected boolean hasMultipleWriteRefs() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBase.hasMultipleWriteRefsImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected String getFileFormatName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoBase.getFileFormatNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoBase() {
        this(Inventor.ConstructorCommand.CreateInstance, SoBase.ctorImplSync());
        SoBase.initCustomClass(this.getNativeResourceHandle(), this);
    }

    public String getName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoBase.getNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void touch() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBase.touchImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSynchronizable() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoBase.isSynchronizableImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoVRMLPROTODef getPROTO(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoVRMLPROTODef soVRMLPROTODef = ObjectManager.getManagedObjectFor(SoVRMLPROTODef.class, SoBase.getPROTOImpl(string));
            return soVRMLPROTODef;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static SoVRMLEXTERNPROTODef getEXTERNPROTO(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoVRMLEXTERNPROTODef soVRMLEXTERNPROTODef = ObjectManager.getManagedObjectFor(SoVRMLEXTERNPROTODef.class, SoBase.getEXTERNPROTOImpl(string));
            return soVRMLEXTERNPROTODef;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void setName(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBase.setNameImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSynchronizable(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBase.setSynchronizableImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    static {
        SoBase.nativeDerivedClassInit();
    }
}

