/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.nodes.SoNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class SoByteStream
extends Inventor {
    private static native void convertImpl(long var0, long var2, boolean var4);

    private static native long[] unconvertImpl(long var0);

    private static native void convertImpl1(long var0, long var2, boolean var4);

    private static native long getNumBytesImpl(long var0);

    private static native Object getDataImpl(long var0);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoByteStream.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoByteStream(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public void convert(SoNode soNode) {
        this.convert(soNode, true);
    }

    public void convert(SoPath soPath) {
        this.convert(soPath, true);
    }

    public SoByteStream() {
        this(Inventor.ConstructorCommand.CreateInstance, SoByteStream.ctorImplSync());
    }

    public void convert(SoPath soPath, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoByteStream.convertImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long getNumBytes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoByteStream.getNumBytesImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static Vector<SoPath> unconvert(SoByteStream soByteStream) {
        Vector<SoPath> vector = null;
        ObjectManager.globalLock.lock();
        try {
            vector = SoByteStream.toVector(SoPath.class, SoByteStream.unconvertImpl(soByteStream != null ? soByteStream.getNativeResourceHandle() : Inventor.ZeroHandle));
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return vector;
    }

    public ByteBuffer getData() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoByteStream.getDataImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public void convert(SoNode soNode, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoByteStream.convertImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

