/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.elements.SoElement;

public class SoState
extends Inventor {
    private static native void enableSendToGLImpl(long var0, boolean var2);

    private static native long getConstElementImpl(long var0, String var2, int var3);

    private static native long getElementImpl(long var0, String var2, int var3);

    private static native boolean isSendToGLEnabledImpl(long var0);

    private static native void popImpl(long var0);

    private static native long getElementImpl1(long var0, int var2);

    private static native void pushImpl(long var0);

    private static native long getConstElementImpl1(long var0, int var2);

    private static native long getActionImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoState(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Deprecated
    public SoElement getElement(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoState.getElementImpl1(this.getNativeResourceHandle(), n));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoAction getAction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAction soAction = ObjectManager.getManagedObjectFor(SoAction.class, SoState.getActionImpl(this.getNativeResourceHandle()));
            return soAction;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoElement getElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoState.getElementImpl(this.getNativeResourceHandle(), string, n));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public SoElement getConstElement(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoState.getConstElementImpl1(this.getNativeResourceHandle(), n));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pop() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoState.popImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void push() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoState.pushImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSendToGLEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoState.isSendToGLEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoElement getConstElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoState.getConstElementImpl(this.getNativeResourceHandle(), string, n));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableSendToGL(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoState.enableSendToGLImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

