/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.nodes.SoGroup;

public class SoTranReceiver
extends Inventor {
    private static native long ctorImpl(long var0);

    private static long ctorImplSync(SoGroup soGroup) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoTranReceiver.ctorImpl(soGroup != null ? soGroup.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean interpretImpl(long var0, long var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoTranReceiver(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoTranReceiver(SoGroup soGroup) {
        this(Inventor.ConstructorCommand.CreateInstance, SoTranReceiver.ctorImplSync(soGroup));
    }

    public boolean interpret(SoInput soInput) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoTranReceiver.interpretImpl(this.getNativeResourceHandle(), soInput != null ? soInput.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

