/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoOutput;
import com.openinventor.inventor.nodes.SoNode;

public class SoTranSender
extends Inventor {
    private static native void removeImpl(long var0, long var2, int var4);

    private static native void insertImpl1(long var0, long var2, long var4, int var6);

    private static native void modifyImpl(long var0, long var2);

    private static native void prepareToSendImpl(long var0);

    private static long ctorImplSync(SoOutput soOutput) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoTranSender.ctorImpl(soOutput != null ? soOutput.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl(long var0);

    private static native void replaceImpl(long var0, long var2, int var4, long var5);

    private static native void insertImpl(long var0, long var2);

    private static native long getOutputImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoTranSender(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void insert(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTranSender.insertImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoOutput getOutput() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoOutput soOutput = ObjectManager.getManagedObjectFor(SoOutput.class, SoTranSender.getOutputImpl(this.getNativeResourceHandle()));
            return soOutput;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoTranSender(SoOutput soOutput) {
        this(Inventor.ConstructorCommand.CreateInstance, SoTranSender.ctorImplSync(soOutput));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(SoNode soNode, SoNode soNode2, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTranSender.insertImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void modify(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTranSender.modifyImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void prepareToSend() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTranSender.prepareToSendImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void remove(SoNode soNode, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTranSender.removeImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(SoNode soNode, int n, SoNode soNode2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTranSender.replaceImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, n, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

