/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.mpeg;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.mpeg.SoMPEGRenderer;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoNode;

public class SoMPEGNavRenderer
extends SoMPEGRenderer {
    private static long ctorImplSync(SoNode soNode) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMPEGNavRenderer.ctorImpl(soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void stopImpl(long var0);

    private static native void recordImpl(long var0);

    private static native long getCameraImpl(long var0);

    private static native void setCameraImpl(long var0, long var2);

    private static native boolean isAdjustedNumFramesPerSecondImpl(long var0);

    private static native long ctorImpl(long var0);

    private static native void adjustNumFramesPerSecondImpl(long var0, boolean var2);

    protected SoMPEGNavRenderer(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    public void record() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGNavRenderer.recordImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoCamera getCamera() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCamera soCamera = ObjectManager.getManagedObjectFor(SoCamera.class, SoMPEGNavRenderer.getCameraImpl(this.getNativeResourceHandle()));
            return soCamera;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void adjustNumFramesPerSecond(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGNavRenderer.adjustNumFramesPerSecondImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void stop() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGNavRenderer.stopImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isAdjustedNumFramesPerSecond() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoMPEGNavRenderer.isAdjustedNumFramesPerSecondImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMPEGNavRenderer(SoNode soNode) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMPEGNavRenderer.ctorImplSync(soNode));
    }

    public void setCamera(SoCamera soCamera) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGNavRenderer.setCameraImpl(this.getNativeResourceHandle(), soCamera != null ? soCamera.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

