/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.mpeg;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.helpers.SbGLShareContext;
import com.openinventor.inventor.nodes.SoNode;

public class SoMPEGRenderer
extends Inventor {
    @Deprecated
    public static final int LUMINANCE = Components.access$000();
    @Deprecated
    public static final int LUMINANCE_TRANSPARENCY = Components.access$100();
    @Deprecated
    public static final int RGB = Components.access$200();
    @Deprecated
    public static final int RGB_TRANSPARENCY = Components.access$300();
    private SoGLRenderAction m_ra_setGLRenderAction;

    private static native void setShareContextImpl(long var0, long var2);

    private static native long getSceneGraphImpl(long var0);

    private static native void addFrameImpl(long var0, byte[] var2);

    private static native void setSceneGraphImpl(long var0, long var2);

    private static native void recordImpl(long var0);

    private static native int getComponentsImpl(long var0);

    private static native void getShareContextImpl(long var0, long var2);

    private static native void setBackgroundColorImpl(long var0, float[] var2);

    private static native void setBitPerSecImpl(long var0, float var2);

    private static native long getGLRenderActionImpl(long var0);

    private static native void setCompressionRateImpl(long var0, float var2);

    private static native void setGLRenderActionImpl(long var0, long var2);

    private static native int getNumFramesPerSecondImpl(long var0);

    private static native void getBackgroundColorImpl(long var0, float[] var2);

    private static native void setNumFramesPerSecondImpl(long var0, float var2);

    private static native void setComponentsImpl(long var0, int var2);

    private static native boolean openFileImpl(long var0, String var2, int var3);

    private static native void closeFileImpl(long var0);

    private static native float getCompressionRateImpl(long var0);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMPEGRenderer.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void stopImpl(long var0);

    private static native void getSizeImpl(long var0, short[] var2);

    private static native void pauseImpl(long var0);

    private static native void setSizeImpl(long var0, short[] var2);

    private static native boolean isViewerIdleImpl(long var0);

    private static native void setViewerIsIdleImpl(long var0, boolean var2);

    private static native boolean isRecordingImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoMPEGRenderer(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean openFile(String string) {
        return this.openFile(string, 10000);
    }

    public SbVec2s getSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.getSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public void setSize(SbVec2s sbVec2s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void stop() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.stopImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isRecording() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoMPEGRenderer.isRecordingImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setViewerIsIdle(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setViewerIsIdleImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void closeFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.closeFileImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openFile(String string, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoMPEGRenderer.openFileImpl(this.getNativeResourceHandle(), string, n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isViewerIdle() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoMPEGRenderer.isViewerIdleImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMPEGRenderer() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMPEGRenderer.ctorImplSync());
    }

    public void setComponents(Components components) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setComponentsImpl(this.getNativeResourceHandle(), components.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_ra_setGLRenderAction = soGLRenderAction;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setGLRenderActionImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setNumFramesPerSecond(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setNumFramesPerSecondImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColor getBackgroundColor() {
        SbColor sbColor = new SbColor();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.getBackgroundColorImpl(this.getNativeResourceHandle(), sbColor.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColor;
    }

    public int getNumFramesPerSecond() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMPEGRenderer.getNumFramesPerSecondImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setCompressionRate(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setCompressionRateImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getCompressionRate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoMPEGRenderer.getCompressionRateImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoGLRenderAction getGLRenderAction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderAction soGLRenderAction = ObjectManager.getManagedObjectFor(SoGLRenderAction.class, SoMPEGRenderer.getGLRenderActionImpl(this.getNativeResourceHandle()));
            return soGLRenderAction;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setBitPerSec(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setBitPerSecImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addFrame(byte[] byArray) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.addFrameImpl(this.getNativeResourceHandle(), byArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void record() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.recordImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSceneGraph(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pause() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.pauseImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Components getComponents() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Components components = IntegerValuedEnumHelper.fromIntValue(Components.class, SoMPEGRenderer.getComponentsImpl(this.getNativeResourceHandle()));
            return components;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setShareContext(SbGLShareContext sbGLShareContext) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext != null ? sbGLShareContext.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setBackgroundColor(SbColor sbColor) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.setBackgroundColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbGLShareContext getShareContext() {
        SbGLShareContext sbGLShareContext = new SbGLShareContext();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMPEGRenderer.getShareContextImpl(this.getNativeResourceHandle(), sbGLShareContext.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbGLShareContext;
    }

    public SoNode getSceneGraph() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoMPEGRenderer.getSceneGraphImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum Components implements IntegerValuedEnum
    {
        LUMINANCE(Components.getLUMINANCE()),
        LUMINANCE_TRANSPARENCY(Components.getLUMINANCETRANSPARENCY()),
        RGB(Components.getRGB()),
        RGB_TRANSPARENCY(Components.getRGBTRANSPARENCY());

        private int value;

        private static native int getRGBTRANSPARENCY();

        private Components(int n2) {
            this.value = n2;
        }

        private static native int getRGB();

        private static native int getLUMINANCE();

        private static native int getLUMINANCETRANSPARENCY();

        @Deprecated
        public static Components fromValue(int n) {
            return Components.valueOf(n);
        }

        public static Components valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Components.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return Components.getLUMINANCE();
        }

        static /* synthetic */ int access$100() {
            return Components.getLUMINANCETRANSPARENCY();
        }

        static /* synthetic */ int access$200() {
            return Components.getRGB();
        }

        static /* synthetic */ int access$300() {
            return Components.getRGBTRANSPARENCY();
        }
    }
}

