/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodekits;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.nodekits.SoBaseKit;
import com.openinventor.inventor.nodekits.SoNodekitCatalog;

public class SoSceneKit
extends SoBaseKit {
    private static native int getCameraNumberImpl(long var0);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoSceneKit.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setCameraNumberImpl(long var0, int var2);

    private static native long getClassNodekitCatalogImpl();

    protected SoSceneKit(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public static SoNodekitCatalog getClassNodekitCatalog() {
        ObjectManager.globalLock.lock();
        try {
            SoNodekitCatalog soNodekitCatalog = ObjectManager.getManagedObjectFor(SoNodekitCatalog.class, SoSceneKit.getClassNodekitCatalogImpl());
            return soNodekitCatalog;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoSceneKit() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSceneKit.ctorImplSync());
    }

    public void setCameraNumber(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneKit.setCameraNumberImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getCameraNumber() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSceneKit.getCameraNumberImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

