/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFNode;
import com.openinventor.inventor.nodes.SoShape;

public class SoCSGShape
extends SoShape {
    @Deprecated
    public static final int ADD = CsgOperationTypes.access$000();
    @Deprecated
    public static final int SUB = CsgOperationTypes.access$100();
    @Deprecated
    public static final int INTERSECTION = CsgOperationTypes.access$200();
    @Deprecated
    public static final int LEFT_ONLY = CsgOperationTypes.access$300();
    @Deprecated
    public static final int RIGHT_ONLY = CsgOperationTypes.access$400();
    @Deprecated
    public static final int NOTHING = CsgOperationTypes.access$500();
    @Deprecated
    public static final int ALL = CsgOperationTypes.access$600();
    @Deprecated
    public static final int CSG_NO_ERROR = CsgStatus.access$700();
    @Deprecated
    public static final int CSG_LIB_NOT_AVAILABLE = CsgStatus.access$800();
    @Deprecated
    public static final int CSG_ERROR = CsgStatus.access$900();
    public final SoSFNode leftOperand;
    public final SoSFNode rightOperand;
    public final SoSFEnum<CsgOperationTypes> csgOperation;

    private static native int getStatusImpl(long var0);

    private static native void setMaxAttemptImpl(long var0, int var2);

    private static native void setRescueOperationImpl(int var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoCSGShape.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    protected SoCSGShape(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.leftOperand = ObjectManager.getManagedObjectFor(SoSFNode.class, SoCSGShape.getFieldHandle(this.getNativeResourceHandle(), "leftOperand"));
        this.rightOperand = ObjectManager.getManagedObjectFor(SoSFNode.class, SoCSGShape.getFieldHandle(this.getNativeResourceHandle(), "rightOperand"));
        this.csgOperation = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoCSGShape.getFieldHandle(this.getNativeResourceHandle(), "csgOperation"), CsgOperationTypes.class);
    }

    static native String getClassTypeId();

    public SoCSGShape() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCSGShape.ctorImplSync());
    }

    public void setMaxAttempt(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCSGShape.setMaxAttemptImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public CsgStatus getStatus() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            CsgStatus csgStatus = IntegerValuedEnumHelper.fromIntValue(CsgStatus.class, SoCSGShape.getStatusImpl(this.getNativeResourceHandle()));
            return csgStatus;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static void setRescueOperation(CsgOperationTypes csgOperationTypes) {
        ObjectManager.globalLock.lock();
        try {
            SoCSGShape.setRescueOperationImpl(csgOperationTypes.getValue());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static enum CsgStatus implements IntegerValuedEnum
    {
        CSG_NO_ERROR(CsgStatus.getCSGNOERROR()),
        CSG_LIB_NOT_AVAILABLE(CsgStatus.getCSGLIBNOTAVAILABLE()),
        CSG_ERROR(CsgStatus.getCSGERROR());

        private int value;

        private static native int getCSGERROR();

        private CsgStatus(int n2) {
            this.value = n2;
        }

        private static native int getCSGNOERROR();

        private static native int getCSGLIBNOTAVAILABLE();

        @Deprecated
        public static CsgStatus fromValue(int n) {
            return CsgStatus.valueOf(n);
        }

        public static CsgStatus valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CsgStatus.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$700() {
            return CsgStatus.getCSGNOERROR();
        }

        static /* synthetic */ int access$800() {
            return CsgStatus.getCSGLIBNOTAVAILABLE();
        }

        static /* synthetic */ int access$900() {
            return CsgStatus.getCSGERROR();
        }
    }

    public static enum CsgOperationTypes implements IntegerValuedEnum
    {
        ADD(CsgOperationTypes.getADD()),
        SUB(CsgOperationTypes.getSUB()),
        INTERSECTION(CsgOperationTypes.getINTERSECTION()),
        LEFT_ONLY(CsgOperationTypes.getLEFTONLY()),
        RIGHT_ONLY(CsgOperationTypes.getRIGHTONLY()),
        NOTHING(CsgOperationTypes.getNOTHING()),
        ALL(CsgOperationTypes.getALL());

        private int value;

        private static native int getNOTHING();

        private static native int getRIGHTONLY();

        private CsgOperationTypes(int n2) {
            this.value = n2;
        }

        private static native int getALL();

        private static native int getSUB();

        private static native int getADD();

        private static native int getLEFTONLY();

        private static native int getINTERSECTION();

        @Deprecated
        public static CsgOperationTypes fromValue(int n) {
            return CsgOperationTypes.valueOf(n);
        }

        public static CsgOperationTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CsgOperationTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return CsgOperationTypes.getADD();
        }

        static /* synthetic */ int access$100() {
            return CsgOperationTypes.getSUB();
        }

        static /* synthetic */ int access$200() {
            return CsgOperationTypes.getINTERSECTION();
        }

        static /* synthetic */ int access$300() {
            return CsgOperationTypes.getLEFTONLY();
        }

        static /* synthetic */ int access$400() {
            return CsgOperationTypes.getRIGHTONLY();
        }

        static /* synthetic */ int access$500() {
            return CsgOperationTypes.getNOTHING();
        }

        static /* synthetic */ int access$600() {
            return CsgOperationTypes.getALL();
        }
    }
}

