/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBitMask;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.nodes.SoShape;

public class SoCylinder
extends SoShape {
    @Deprecated
    public static final int SIDES = PartType.access$000();
    @Deprecated
    public static final int TOP = PartType.access$100();
    @Deprecated
    public static final int BOTTOM = PartType.access$200();
    @Deprecated
    public static final int ALL = PartType.access$300();
    public final SoSFBitMask<PartType> parts;
    public final SoSFFloat radius;
    public final SoSFFloat height;

    private static native void addPartImpl(long var0, int var2);

    private static native void removePartImpl(long var0, int var2);

    private static native boolean hasPartImpl(long var0, int var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoCylinder.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    protected SoCylinder(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.parts = ObjectManager.getManagedObjectFor(SoSFBitMask.class, SoCylinder.getFieldHandle(this.getNativeResourceHandle(), "parts"), PartType.class);
        this.radius = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCylinder.getFieldHandle(this.getNativeResourceHandle(), "radius"));
        this.height = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCylinder.getFieldHandle(this.getNativeResourceHandle(), "height"));
    }

    static native String getClassTypeId();

    public boolean hasPart(PartType partType) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCylinder.hasPartImpl(this.getNativeResourceHandle(), partType.getValue());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removePart(PartType partType) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCylinder.removePartImpl(this.getNativeResourceHandle(), partType.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addPart(PartType partType) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCylinder.addPartImpl(this.getNativeResourceHandle(), partType.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoCylinder() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCylinder.ctorImplSync());
    }

    public static enum PartType implements IntegerValuedEnum
    {
        SIDES(PartType.getSIDES()),
        TOP(PartType.getTOP()),
        BOTTOM(PartType.getBOTTOM()),
        ALL(PartType.getALL());

        private int value;

        private static native int getALL();

        private PartType(int n2) {
            this.value = n2;
        }

        private static native int getBOTTOM();

        private static native int getSIDES();

        private static native int getTOP();

        @Deprecated
        public static PartType fromValue(int n) {
            return PartType.valueOf(n);
        }

        public static PartType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(PartType.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return PartType.getSIDES();
        }

        static /* synthetic */ int access$100() {
            return PartType.getTOP();
        }

        static /* synthetic */ int access$200() {
            return PartType.getBOTTOM();
        }

        static /* synthetic */ int access$300() {
            return PartType.getALL();
        }
    }
}

