/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.SoPickedPoint;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.SoNode;

public class SoEventCallback
extends SoNode {
    public void addEventCallback(Class clazz, SoEventCallbackCB soEventCallbackCB) {
        this.addEventCallback(clazz.getName(), soEventCallbackCB, null);
    }

    public void addEventCallback(Class clazz, SoEventCallbackCB soEventCallbackCB, Object object) {
        this.addEventCallback(clazz.getName(), soEventCallbackCB, object);
    }

    public void addEventCallback(String string, SoEventCallbackCB soEventCallbackCB, Object object) {
        SoEventCallback.addEventCallbackImpl(this.getNativeResourceHandle(), string, soEventCallbackCB, object);
    }

    private static native void addEventCallbackImpl(long var0, String var2, SoEventCallbackCB var3, Object var4);

    public void removeEventCallback(Class clazz, SoEventCallbackCB soEventCallbackCB, Object object) {
        this.removeEventCallback(clazz.getName(), soEventCallbackCB, object);
    }

    public void removeEventCallback(String string, SoEventCallbackCB soEventCallbackCB, Object object) {
        SoEventCallback.removeEventCallbackImpl(this.getNativeResourceHandle(), string, soEventCallbackCB, object);
    }

    private static native void removeEventCallbackImpl(long var0, String var2, SoEventCallbackCB var3, Object var4);

    private static native long getPickedPointImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoEventCallback.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getActionImpl(long var0);

    private static native long getEventImpl(long var0);

    private static native void releaseEventsImpl(long var0);

    private static native boolean isHandledImpl(long var0);

    private static native void grabEventsImpl(long var0);

    private static native long getPathImpl(long var0);

    private static native long ctorImpl();

    private static native void setHandledImpl(long var0);

    private static native void setPathImpl(long var0, long var2);

    protected SoEventCallback(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoPickedPoint getPickedPoint() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPickedPoint soPickedPoint = ObjectManager.getManagedObjectFor(SoPickedPoint.class, SoEventCallback.getPickedPointImpl(this.getNativeResourceHandle()));
            return soPickedPoint;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPath(SoPath soPath) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEventCallback.setPathImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoEvent getEvent() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEvent soEvent = ObjectManager.getManagedObjectFor(SoEvent.class, SoEventCallback.getEventImpl(this.getNativeResourceHandle()));
            return soEvent;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoHandleEventAction getAction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoHandleEventAction soHandleEventAction = ObjectManager.getManagedObjectFor(SoHandleEventAction.class, SoEventCallback.getActionImpl(this.getNativeResourceHandle()));
            return soHandleEventAction;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getPath() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoEventCallback.getPathImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void grabEvents() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEventCallback.grabEventsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void releaseEvents() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEventCallback.releaseEventsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoEventCallback() {
        this(Inventor.ConstructorCommand.CreateInstance, SoEventCallback.ctorImplSync());
    }

    public void setHandled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoEventCallback.setHandledImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isHandled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoEventCallback.isHandledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

