/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSelection;
import com.openinventor.inventor.nodes.SoSeparator;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Vector;

public class SoExtSelection
extends SoSelection {
    @Deprecated
    public static final int NOLASSO = LassoTypes.access$200();
    @Deprecated
    public static final int LASSO = LassoTypes.access$300();
    @Deprecated
    public static final int RECTANGLE = LassoTypes.access$400();
    @Deprecated
    public static final int ELLIPSE = LassoTypes.access$500();
    @Deprecated
    public static final int FULL_BBOX = LassoPolicies.access$600();
    @Deprecated
    public static final int PART_BBOX = LassoPolicies.access$700();
    @Deprecated
    public static final int FULL = LassoPolicies.access$800();
    @Deprecated
    public static final int PART = LassoPolicies.access$900();
    @Deprecated
    public static final int VISIBLE_SHAPES = LassoModes.access$1000();
    @Deprecated
    public static final int ALL_SHAPES = LassoModes.access$1100();
    @Deprecated
    public static final int NOSELECT_CONTINUE = ReturnTypes.access$1200();
    @Deprecated
    public static final int SELECT_RETURN = ReturnTypes.access$1300();
    @Deprecated
    public static final int SELECT_CONTINUE = ReturnTypes.access$1400();
    @Deprecated
    public static final int NOSELECT_RETURN = ReturnTypes.access$1500();
    public final SoSFEnum<LassoTypes> lassoType;
    public final SoSFEnum<LassoPolicies> lassoPolicy;
    public final SoSFEnum<LassoModes> lassoMode;
    public final SbEventHandler<PreFilterEventArg> onPreFilter;

    private static native long getLassoCoordsWCImpl(long var0, int[] var2);

    private static native long[] getSelectionPathListImpl(long var0);

    private static native long getOverlaySceneGraphImpl(long var0);

    private static native void setOverlayLassoColorIndexImpl(long var0, int var2);

    private static native boolean isUsingFastEditingImpl(long var0);

    private static native void setLassoColorImpl(long var0, float[] var2);

    private static native void getLassoColorImpl(long var0, float[] var2);

    private static native int getOverlayLassoColorIndexImpl(long var0);

    private static native void useFastEditingImpl(long var0, boolean var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoExtSelection.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long addOnPreFilterEventHandler(long var0, OnPreFilterEventHandler var2, String var3);

    private static native boolean removeOnPreFilterEventHandler(long var0, long var2);

    private static native boolean isUsingOverlayImpl(long var0);

    private static native long ctorImpl();

    private static native void useOverlayImpl(long var0, boolean var2);

    private static native void setSelectionSceneGraphImpl(long var0, long var2);

    private static native long getSelectionSceneGraphImpl(long var0);

    private static native void selectImpl(long var0, long var2, int var4, Object[] var5, long var6, boolean var8);

    private static native long getLassoCoordsDCImpl(long var0, int[] var2);

    private static native Object getDirectLassoCoordsWCImpl(long var0, int[] var2);

    private static native Object getDirectLassoCoordsDCImpl(long var0, int[] var2);

    private static native float getLassoWidthImpl(long var0);

    private static native void setOverlayLassoPatternImpl(long var0, short var2);

    private static native void setLassoWidthImpl(long var0, float var2);

    private static native void animateOverlayLassoImpl(long var0, boolean var2);

    private static native boolean isOverlayLassoAnimatedImpl(long var0);

    private static native short getOverlayLassoPatternImpl(long var0);

    protected SoExtSelection(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.lassoType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoType"), LassoTypes.class);
        this.lassoPolicy = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoPolicy"), LassoPolicies.class);
        this.lassoMode = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoExtSelection.getFieldHandle(this.getNativeResourceHandle(), "lassoMode"), LassoModes.class);
        this.onPreFilter = new OnPreFilterEventHandler();
    }

    static native String getClassTypeId();

    public void animateOverlayLasso() {
        this.animateOverlayLasso(true);
    }

    public void useFastEditing() {
        this.useFastEditing(true);
    }

    @Deprecated
    public void useOverlay() {
        this.useOverlay(true);
    }

    @Deprecated
    public boolean isUsingOverlay() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoExtSelection.isUsingOverlayImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public void useOverlay(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.useOverlayImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoExtSelection() {
        this(Inventor.ConstructorCommand.CreateInstance, SoExtSelection.ctorImplSync());
    }

    public SoSeparator getOverlaySceneGraph() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSeparator soSeparator = ObjectManager.getManagedObjectFor(SoSeparator.class, SoExtSelection.getOverlaySceneGraphImpl(this.getNativeResourceHandle()));
            return soSeparator;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isUsingFastEditing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoExtSelection.isUsingFastEditingImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void useFastEditing(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.useFastEditingImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3f[] getLassoCoordsWC() {
        int[] nArray = new int[1];
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoExtSelection.getLassoCoordsWCImpl(this.getNativeResourceHandle(), nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbVec3f.toArray(l, nArray[0]);
    }

    public Vector<SoPath> getSelectionPathList() {
        Vector<SoPath> vector = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            vector = SoExtSelection.toVector(SoPath.class, SoExtSelection.getSelectionPathListImpl(this.getNativeResourceHandle()));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(SoNode soNode, SbVec2f[] sbVec2fArray, SbViewportRegion sbViewportRegion, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.selectImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec2fArray.length, sbVec2fArray, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ShortBuffer getDirectLassoCoordsDC() {
        int[] nArray = new int[1];
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoExtSelection.getDirectLassoCoordsDCImpl(this.getNativeResourceHandle(), nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asShortBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec2s[] getLassoCoordsDC() {
        int[] nArray = new int[1];
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = SoExtSelection.getLassoCoordsDCImpl(this.getNativeResourceHandle(), nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbVec2s.toArray(l, nArray[0]);
    }

    public FloatBuffer getDirectLassoCoordsWC() {
        int[] nArray = new int[1];
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoExtSelection.getDirectLassoCoordsWCImpl(this.getNativeResourceHandle(), nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public void animateOverlayLasso(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.animateOverlayLassoImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public short getOverlayLassoPattern() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            short s = SoExtSelection.getOverlayLassoPatternImpl(this.getNativeResourceHandle());
            return s;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setOverlayLassoPattern(short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.setOverlayLassoPatternImpl(this.getNativeResourceHandle(), s);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSelectionSceneGraph(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.setSelectionSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getSelectionSceneGraph() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoExtSelection.getSelectionSceneGraphImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isOverlayLassoAnimated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoExtSelection.isOverlayLassoAnimatedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setLassoColor(SbColor sbColor) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.setLassoColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getOverlayLassoColorIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoExtSelection.getOverlayLassoColorIndexImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setOverlayLassoColorIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.setOverlayLassoColorIndexImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getLassoWidth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoExtSelection.getLassoWidthImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setLassoWidth(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.setLassoWidthImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbColor getLassoColor() {
        SbColor sbColor = new SbColor();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoExtSelection.getLassoColorImpl(this.getNativeResourceHandle(), sbColor.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColor;
    }

    private class OnPreFilterEventHandler
    extends SbEventHandler<PreFilterEventArg> {
        private OnPreFilterEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoExtSelection.removeOnPreFilterEventHandler(SoExtSelection.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = PreFilterEventArg.class.getName();
            this.m_nativeEventHandler = SoExtSelection.addOnPreFilterEventHandler(SoExtSelection.this.getNativeResourceHandle(), this, string);
        }
    }

    public static class PreFilterEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native void skipNodeImpl(long var0);

        private static native long getNodeImpl(long var0);

        private static native long getPathImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        private static native boolean isNodeSkippedImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected PreFilterEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public SoPath getPath() {
            return ObjectManager.getManagedObjectFor(SoPath.class, PreFilterEventArg.getPathImpl(this.getNativeResourceHandle()));
        }

        public PreFilterEventArg(SoPath soPath, SoExtSelection soExtSelection) {
            this(Inventor.ConstructorCommand.CreateInstance, PreFilterEventArg.ctorImpl(soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, soExtSelection != null ? soExtSelection.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public void setValue(PreFilterEventArg preFilterEventArg) {
            PreFilterEventArg.setValueImpl(this.getNativeResourceHandle(), preFilterEventArg.getNativeResourceHandle());
        }

        public void skipNode() {
            PreFilterEventArg.skipNodeImpl(this.getNativeResourceHandle());
        }

        public SoNode getNode() {
            return ObjectManager.getManagedObjectFor(SoNode.class, PreFilterEventArg.getNodeImpl(this.getNativeResourceHandle()));
        }

        public boolean isNodeSkipped() {
            return PreFilterEventArg.isNodeSkippedImpl(this.getNativeResourceHandle());
        }

        @Override
        public SoExtSelection getSource() {
            return ObjectManager.getManagedObjectFor(SoExtSelection.class, PreFilterEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static enum ReturnTypes implements IntegerValuedEnum
    {
        NOSELECT_CONTINUE(ReturnTypes.getNOSELECTCONTINUE()),
        SELECT_RETURN(ReturnTypes.getSELECTRETURN()),
        SELECT_CONTINUE(ReturnTypes.getSELECTCONTINUE()),
        NOSELECT_RETURN(ReturnTypes.getNOSELECTRETURN());

        private int value;

        private static native int getNOSELECTRETURN();

        private ReturnTypes(int n2) {
            this.value = n2;
        }

        private static native int getSELECTCONTINUE();

        private static native int getNOSELECTCONTINUE();

        private static native int getSELECTRETURN();

        @Deprecated
        public static ReturnTypes fromValue(int n) {
            return ReturnTypes.valueOf(n);
        }

        public static ReturnTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ReturnTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$1200() {
            return ReturnTypes.getNOSELECTCONTINUE();
        }

        static /* synthetic */ int access$1300() {
            return ReturnTypes.getSELECTRETURN();
        }

        static /* synthetic */ int access$1400() {
            return ReturnTypes.getSELECTCONTINUE();
        }

        static /* synthetic */ int access$1500() {
            return ReturnTypes.getNOSELECTRETURN();
        }
    }

    public static enum LassoModes implements IntegerValuedEnum
    {
        VISIBLE_SHAPES(LassoModes.getVISIBLESHAPES()),
        ALL_SHAPES(LassoModes.getALLSHAPES());

        private int value;

        private LassoModes(int n2) {
            this.value = n2;
        }

        private static native int getALLSHAPES();

        private static native int getVISIBLESHAPES();

        @Deprecated
        public static LassoModes fromValue(int n) {
            return LassoModes.valueOf(n);
        }

        public static LassoModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LassoModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$1000() {
            return LassoModes.getVISIBLESHAPES();
        }

        static /* synthetic */ int access$1100() {
            return LassoModes.getALLSHAPES();
        }
    }

    public static enum LassoPolicies implements IntegerValuedEnum
    {
        FULL_BBOX(LassoPolicies.getFULLBBOX()),
        PART_BBOX(LassoPolicies.getPARTBBOX()),
        FULL(LassoPolicies.getFULL()),
        PART(LassoPolicies.getPART());

        private int value;

        private static native int getPART();

        private LassoPolicies(int n2) {
            this.value = n2;
        }

        private static native int getFULL();

        private static native int getFULLBBOX();

        private static native int getPARTBBOX();

        @Deprecated
        public static LassoPolicies fromValue(int n) {
            return LassoPolicies.valueOf(n);
        }

        public static LassoPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LassoPolicies.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$600() {
            return LassoPolicies.getFULLBBOX();
        }

        static /* synthetic */ int access$700() {
            return LassoPolicies.getPARTBBOX();
        }

        static /* synthetic */ int access$800() {
            return LassoPolicies.getFULL();
        }

        static /* synthetic */ int access$900() {
            return LassoPolicies.getPART();
        }
    }

    public static enum LassoTypes implements IntegerValuedEnum
    {
        NOLASSO(LassoTypes.getNOLASSO()),
        LASSO(LassoTypes.getLASSO()),
        RECTANGLE(LassoTypes.getRECTANGLE()),
        ELLIPSE(LassoTypes.getELLIPSE());

        private int value;

        private static native int getELLIPSE();

        private LassoTypes(int n2) {
            this.value = n2;
        }

        private static native int getRECTANGLE();

        private static native int getNOLASSO();

        private static native int getLASSO();

        @Deprecated
        public static LassoTypes fromValue(int n) {
            return LassoTypes.valueOf(n);
        }

        public static LassoTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LassoTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$200() {
            return LassoTypes.getNOLASSO();
        }

        static /* synthetic */ int access$300() {
            return LassoTypes.getLASSO();
        }

        static /* synthetic */ int access$400() {
            return LassoTypes.getRECTANGLE();
        }

        static /* synthetic */ int access$500() {
            return LassoTypes.getELLIPSE();
        }
    }
}

