/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.nodes.SoNode;

public class SoFont
extends SoNode {
    @Deprecated
    public static final int POLYGON = RenderStyles.access$000();
    @Deprecated
    public static final int TEXTURE = RenderStyles.access$100();
    @Deprecated
    public static final int TEXTURE_DELAYED = RenderStyles.access$200();
    @Deprecated
    public static final int POLYGON_AND_OUTLINE = RenderStyles.access$300();
    public final SoSFString name;
    public final SoSFFloat size;
    public final SoSFEnum<RenderStyles> renderStyle;

    private static native String getFontPathsImpl();

    private static native boolean isAvailableFontImpl(String var0);

    private static native void addFontPathsImpl(String var0);

    private static native int getCurrNumFontCachesImpl();

    private static native void setFontPathsImpl(String var0);

    private static native long ctorImpl();

    private static native boolean isMCSJapaneseSFEnabledImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoFont.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void enableMCSJapaneseSFImpl(boolean var0);

    private static native void enableJapaneseSFImpl(boolean var0);

    private static native void setNumFontCachesImpl(int var0);

    private static native void clearFontNameCacheImpl();

    private static native boolean isJapaneseSFEnabledImpl();

    private static native int getNumFontCachesImpl();

    protected SoFont(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.name = ObjectManager.getManagedObjectFor(SoSFString.class, SoFont.getFieldHandle(this.getNativeResourceHandle(), "name"));
        this.size = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoFont.getFieldHandle(this.getNativeResourceHandle(), "size"));
        this.renderStyle = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoFont.getFieldHandle(this.getNativeResourceHandle(), "renderStyle"), RenderStyles.class);
    }

    static native String getClassTypeId();

    public static void enableJapaneseSF() {
        SoFont.enableJapaneseSF(true);
    }

    @Deprecated
    public static void enableMCSJapaneseSF() {
        SoFont.enableMCSJapaneseSF(true);
    }

    public static int getNumFontCaches() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoFont.getNumFontCachesImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void addFontPaths(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoFont.addFontPathsImpl(string);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static int getCurrNumFontCaches() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoFont.getCurrNumFontCachesImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoFont() {
        this(Inventor.ConstructorCommand.CreateInstance, SoFont.ctorImplSync());
    }

    public static void setFontPaths(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoFont.setFontPathsImpl(string);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static String getFontPaths() {
        ObjectManager.globalLock.lock();
        try {
            String string = SoFont.getFontPathsImpl();
            return string;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean isJapaneseSFEnabled() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoFont.isJapaneseSFEnabledImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static void enableMCSJapaneseSF(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoFont.enableMCSJapaneseSFImpl(bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static boolean isMCSJapaneseSFEnabled() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoFont.isMCSJapaneseSFEnabledImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void clearFontNameCache() {
        ObjectManager.globalLock.lock();
        try {
            SoFont.clearFontNameCacheImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setNumFontCaches(int n) {
        ObjectManager.globalLock.lock();
        try {
            SoFont.setNumFontCachesImpl(n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void enableJapaneseSF(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            SoFont.enableJapaneseSFImpl(bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean isAvailableFont(String string) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoFont.isAvailableFontImpl(string);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static enum RenderStyles implements IntegerValuedEnum
    {
        POLYGON(RenderStyles.getPOLYGON()),
        TEXTURE(RenderStyles.getTEXTURE()),
        TEXTURE_DELAYED(RenderStyles.getTEXTUREDELAYED()),
        POLYGON_AND_OUTLINE(RenderStyles.getPOLYGONANDOUTLINE());

        private int value;

        private static native int getPOLYGONANDOUTLINE();

        private RenderStyles(int n2) {
            this.value = n2;
        }

        private static native int getTEXTUREDELAYED();

        private static native int getPOLYGON();

        private static native int getTEXTURE();

        @Deprecated
        public static RenderStyles fromValue(int n) {
            return RenderStyles.valueOf(n);
        }

        public static RenderStyles valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(RenderStyles.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return RenderStyles.getPOLYGON();
        }

        static /* synthetic */ int access$100() {
            return RenderStyles.getTEXTURE();
        }

        static /* synthetic */ int access$200() {
            return RenderStyles.getTEXTUREDELAYED();
        }

        static /* synthetic */ int access$300() {
            return RenderStyles.getPOLYGONANDOUTLINE();
        }
    }
}

