/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoCallbackAction;
import com.openinventor.inventor.actions.SoDistributeAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.actions.SoGetMatrixAction;
import com.openinventor.inventor.actions.SoGetPrimitiveCountAction;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.actions.SoPickAction;
import com.openinventor.inventor.actions.SoRayPickAction;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.actions.SoWriteAction;
import com.openinventor.inventor.fields.SoFieldContainer;

public class SoNode
extends SoFieldContainer {
    protected void internalTraverse(SoAction soAction) {
        ObjectManager.globalLock.lock();
        try {
            SoNode.internalTraverseImpl(this.getNativeResourceHandle(), soAction.getNativeResourceHandle());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void internalTraverseImpl(long var0, long var2);

    private static native void rayPickImpl(long var0, long var2);

    private static native void searchImpl(long var0, long var2);

    private static native void pickImpl(long var0, long var2);

    private static native void getMatrixImpl(long var0, long var2);

    private static native void handleEventImpl(long var0, long var2);

    private static native void GLRenderBelowPathImpl(long var0, long var2);

    private static native void GLRenderInPathImpl(long var0, long var2);

    private static native void distributeImpl(long var0, long var2);

    private static native void writeImpl(long var0, long var2);

    private static native void getPrimitiveCountImpl(long var0, long var2);

    private static native void incNextActionMethodIndexImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoNode.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native int getNextActionMethodIndexImpl();

    private static native void setChildrenSameFieldsValueNotificationEnabledImpl(long var0, boolean var2);

    private static native void setNextActionMethodIndexImpl(int var0);

    private static native void callbackImpl(long var0, long var2);

    private static native void getBoundingBoxImpl(long var0, long var2);

    private static native void GLRenderImpl(long var0, long var2);

    private static native boolean isBoundingBoxIgnoringImpl(long var0);

    private static native void doActionImpl(long var0, long var2);

    private static native void initCustomClass(long var0, Inventor var2, boolean var3, String var4);

    private static native void nativeDerivedClassInit();

    private static native int getRenderUnitIDImpl(long var0);

    private static native long ctorImpl();

    private static native void grabEventsCleanupImpl(long var0);

    private static native void GLRenderOffPathImpl(long var0, long var2);

    private static native void grabEventsSetupImpl(long var0);

    private static native long getByNameImpl(String var0);

    private static native void setOverrideImpl(long var0, boolean var2);

    private static native long copyImpl(long var0, boolean var2);

    private static native boolean isOverrideImpl(long var0);

    private static native boolean affectsStateImpl(long var0);

    private static native void touchImpl(long var0);

    private static native long getAlternateRepImpl(long var0, long var2);

    private static native void internalAddChildImpl(long var0, long var2);

    protected SoNode(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoNode(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoNode copy() {
        return this.copy(false);
    }

    protected void internalAddChild(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.internalAddChildImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoNode() {
        this(Inventor.ConstructorCommand.CreateInstance, SoNode.ctorImplSync());
        Class<?> clazz = this.getClass();
        SoNode.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz));
    }

    protected static void setNextActionMethodIndex(int n) {
        ObjectManager.globalLock.lock();
        try {
            SoNode.setNextActionMethodIndexImpl(n);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected void setChildrenSameFieldsValueNotificationEnabled(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.setChildrenSameFieldsValueNotificationEnabledImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected static int getNextActionMethodIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoNode.getNextActionMethodIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected static void incNextActionMethodIndex() {
        ObjectManager.globalLock.lock();
        try {
            SoNode.incNextActionMethodIndexImpl();
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void callback(SoCallbackAction soCallbackAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.callbackImpl(this.getNativeResourceHandle(), soCallbackAction != null ? soCallbackAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setOverride(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.setOverrideImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoNode getByName(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoNode.getByNameImpl(string));
            return soNode;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoNode copy(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoNode.copyImpl(this.getNativeResourceHandle(), bl));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean affectsState() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoNode.affectsStateImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isOverride() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoNode.isOverrideImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void doAction(SoAction soAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.doActionImpl(this.getNativeResourceHandle(), soAction != null ? soAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void rayPick(SoRayPickAction soRayPickAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.rayPickImpl(this.getNativeResourceHandle(), soRayPickAction != null ? soRayPickAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void search(SoSearchAction soSearchAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.searchImpl(this.getNativeResourceHandle(), soSearchAction != null ? soSearchAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isBoundingBoxIgnoring() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoNode.isBoundingBoxIgnoringImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void write(SoWriteAction soWriteAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.writeImpl(this.getNativeResourceHandle(), soWriteAction != null ? soWriteAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void getMatrix(SoGetMatrixAction soGetMatrixAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.getMatrixImpl(this.getNativeResourceHandle(), soGetMatrixAction != null ? soGetMatrixAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void getBoundingBox(SoGetBoundingBoxAction soGetBoundingBoxAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.getBoundingBoxImpl(this.getNativeResourceHandle(), soGetBoundingBoxAction != null ? soGetBoundingBoxAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void handleEvent(SoHandleEventAction soHandleEventAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.handleEventImpl(this.getNativeResourceHandle(), soHandleEventAction != null ? soHandleEventAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pick(SoPickAction soPickAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.pickImpl(this.getNativeResourceHandle(), soPickAction != null ? soPickAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void GLRender(SoGLRenderAction soGLRenderAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.GLRenderImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void grabEventsSetup() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.grabEventsSetupImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void GLRenderOffPath(SoGLRenderAction soGLRenderAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.GLRenderOffPathImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void grabEventsCleanup() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.grabEventsCleanupImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void touch() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.touchImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getRenderUnitID() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoNode.getRenderUnitIDImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void distribute(SoDistributeAction soDistributeAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.distributeImpl(this.getNativeResourceHandle(), soDistributeAction != null ? soDistributeAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void getPrimitiveCount(SoGetPrimitiveCountAction soGetPrimitiveCountAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.getPrimitiveCountImpl(this.getNativeResourceHandle(), soGetPrimitiveCountAction != null ? soGetPrimitiveCountAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getAlternateRep(SoAction soAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoNode.getAlternateRepImpl(this.getNativeResourceHandle(), soAction != null ? soAction.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void GLRenderInPath(SoGLRenderAction soGLRenderAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.GLRenderInPathImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void GLRenderBelowPath(SoGLRenderAction soGLRenderAction) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode.GLRenderBelowPathImpl(this.getNativeResourceHandle(), soGLRenderAction != null ? soGLRenderAction.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    static {
        SoNode.nativeDerivedClassInit();
    }
}

