/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.nodes.SoSeparator;

public class SoRenderList
extends SoSeparator {
    public final SoSFBool isHead;

    private static native void removeAllRenderObjectNamesImpl(long var0);

    private static native int getNumRenderObjectNamesImpl(long var0);

    private static native String getRenderObjectNameImpl(long var0, int var2);

    private static native long ctorImpl1(int var0);

    private static native void addRenderObjectTypeImpl(long var0, String var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoRenderList.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImpl1Sync(int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoRenderList.ctorImpl1(n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native void removeRenderObjectTypeImpl(long var0, String var2);

    private static native void addRenderObjectNameImpl(long var0, String var2);

    private static native void removeRenderObjectNameImpl(long var0, String var2);

    private static native int getNumRenderObjectTypesImpl(long var0);

    private static native String getRenderObjectTypeImpl(long var0, int var2);

    protected SoRenderList(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.isHead = ObjectManager.getManagedObjectFor(SoSFBool.class, SoRenderList.getFieldHandle(this.getNativeResourceHandle(), "isHead"));
    }

    static native String getClassTypeId();

    public SoRenderList() {
        this(Inventor.ConstructorCommand.CreateInstance, SoRenderList.ctorImplSync());
    }

    public SoRenderList(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoRenderList.ctorImpl1Sync(n));
    }

    public String getRenderObjectName(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoRenderList.getRenderObjectNameImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Class<? extends Inventor> getRenderObjectClass(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Class<? extends Inventor> clazz = NativeTypeMap.getJavaClass(SoRenderList.getRenderObjectTypeImpl(this.getNativeResourceHandle(), n));
            return clazz;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeAllRenderObjectNames() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderList.removeAllRenderObjectNamesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addRenderObjectClass(Class<? extends Inventor> clazz) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderList.addRenderObjectTypeImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeRenderObjectName(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderList.removeRenderObjectNameImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addRenderObjectName(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderList.addRenderObjectNameImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumRenderObjectNames() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoRenderList.getNumRenderObjectNamesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeRenderObjectClass(Class<? extends Inventor> clazz) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderList.removeRenderObjectTypeImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumRenderObjectTypes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoRenderList.getNumRenderObjectTypesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

