/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SoPath;

public class SoRenderObject
extends Inventor {
    private static native boolean hasIndexImpl(long var0);

    private static native long getPathImpl(long var0);

    private static native int getIndexImpl(long var0);

    private static native void setDecimationImpl(long var0, float var2);

    private static native void setIndexImpl(long var0, int var2);

    private static native void getBoxImpl(long var0, float[] var2);

    private static native long ctorImpl(long var0);

    private static native float getDecimationImpl(long var0);

    private static long ctorImplSync(SoPath soPath) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoRenderObject.ctorImpl(soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void invalidateImpl(long var0);

    private static native void resetIndexImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoRenderObject(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void resetIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderObject.resetIndexImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getPath() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoRenderObject.getPathImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoRenderObject(SoPath soPath) {
        this(Inventor.ConstructorCommand.CreateInstance, SoRenderObject.ctorImplSync(soPath));
    }

    public void invalidate() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderObject.invalidateImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoRenderObject.getIndexImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderObject.setIndexImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setDecimation(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderObject.setDecimationImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getDecimation() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoRenderObject.getDecimationImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbBox3f getBox() {
        SbBox3f sbBox3f = new SbBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderObject.getBoxImpl(this.getNativeResourceHandle(), sbBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbBox3f;
    }

    public boolean hasIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoRenderObject.hasIndexImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

