/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFUniformShaderParameter;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFilePathString;
import com.openinventor.inventor.nodes.SoNode;

public abstract class SoShaderObject
extends SoNode {
    @Deprecated
    public static final int ARB_PROGRAM = SourceTypes.access$000();
    @Deprecated
    public static final int CG_PROGRAM = SourceTypes.access$100();
    @Deprecated
    public static final int GLSL_PROGRAM = SourceTypes.access$200();
    @Deprecated
    public static final int FILENAME = SourceTypes.access$300();
    @Deprecated
    public static final int VERTEX_SHADER = ShaderTypes.access$400();
    @Deprecated
    public static final int GEOMETRY_SHADER = ShaderTypes.access$500();
    @Deprecated
    public static final int FRAGMENT_SHADER = ShaderTypes.access$600();
    @Deprecated
    public static final int TESSELLATION_CONTROL_SHADER = ShaderTypes.access$700();
    @Deprecated
    public static final int TESSELLATION_EVALUATION_SHADER = ShaderTypes.access$800();
    public final SoSFBool isActive;
    public final SoSFEnum<SourceTypes> sourceType;
    public final SoSFFilePathString sourceProgram;
    public final SoMFUniformShaderParameter parameter;

    private static native int getShaderTypeImpl(long var0);

    protected SoShaderObject(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.isActive = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "isActive"));
        this.sourceType = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "sourceType"), SourceTypes.class);
        this.sourceProgram = ObjectManager.getManagedObjectFor(SoSFFilePathString.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "sourceProgram"));
        this.parameter = ObjectManager.getManagedObjectFor(SoMFUniformShaderParameter.class, SoShaderObject.getFieldHandle(this.getNativeResourceHandle(), "parameter"));
    }

    static native String getClassTypeId();

    public ShaderTypes getShaderType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ShaderTypes shaderTypes = IntegerValuedEnumHelper.fromIntValue(ShaderTypes.class, SoShaderObject.getShaderTypeImpl(this.getNativeResourceHandle()));
            return shaderTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum ShaderTypes implements IntegerValuedEnum
    {
        VERTEX_SHADER(ShaderTypes.getVERTEXSHADER()),
        GEOMETRY_SHADER(ShaderTypes.getGEOMETRYSHADER()),
        FRAGMENT_SHADER(ShaderTypes.getFRAGMENTSHADER()),
        TESSELLATION_CONTROL_SHADER(ShaderTypes.getTESSELLATIONCONTROLSHADER()),
        TESSELLATION_EVALUATION_SHADER(ShaderTypes.getTESSELLATIONEVALUATIONSHADER());

        private int value;

        private static native int getTESSELLATIONCONTROLSHADER();

        private static native int getTESSELLATIONEVALUATIONSHADER();

        private ShaderTypes(int n2) {
            this.value = n2;
        }

        private static native int getVERTEXSHADER();

        private static native int getGEOMETRYSHADER();

        private static native int getFRAGMENTSHADER();

        @Deprecated
        public static ShaderTypes fromValue(int n) {
            return ShaderTypes.valueOf(n);
        }

        public static ShaderTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShaderTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$400() {
            return ShaderTypes.getVERTEXSHADER();
        }

        static /* synthetic */ int access$500() {
            return ShaderTypes.getGEOMETRYSHADER();
        }

        static /* synthetic */ int access$600() {
            return ShaderTypes.getFRAGMENTSHADER();
        }

        static /* synthetic */ int access$700() {
            return ShaderTypes.getTESSELLATIONCONTROLSHADER();
        }

        static /* synthetic */ int access$800() {
            return ShaderTypes.getTESSELLATIONEVALUATIONSHADER();
        }
    }

    public static enum SourceTypes implements IntegerValuedEnum
    {
        ARB_PROGRAM(SourceTypes.getARBPROGRAM()),
        CG_PROGRAM(SourceTypes.getCGPROGRAM()),
        GLSL_PROGRAM(SourceTypes.getGLSLPROGRAM()),
        FILENAME(SourceTypes.getFILENAME());

        private int value;

        private static native int getFILENAME();

        private SourceTypes(int n2) {
            this.value = n2;
        }

        private static native int getGLSLPROGRAM();

        private static native int getARBPROGRAM();

        private static native int getCGPROGRAM();

        @Deprecated
        public static SourceTypes fromValue(int n) {
            return SourceTypes.valueOf(n);
        }

        public static SourceTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SourceTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return SourceTypes.getARBPROGRAM();
        }

        static /* synthetic */ int access$100() {
            return SourceTypes.getCGPROGRAM();
        }

        static /* synthetic */ int access$200() {
            return SourceTypes.getGLSLPROGRAM();
        }

        static /* synthetic */ int access$300() {
            return SourceTypes.getFILENAME();
        }
    }
}

