/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;

public abstract class SoShape
extends SoNode {
    @Deprecated
    public static final int POINTS = ShapeTypes.access$000();
    @Deprecated
    public static final int LINES = ShapeTypes.access$100();
    @Deprecated
    public static final int POLYGONS = ShapeTypes.access$200();
    @Deprecated
    public static final int TEXT = ShapeTypes.access$300();
    public final SoSFBool boundingBoxIgnoring;

    private static native boolean isPrimitiveRestartAvailableImpl(long var0);

    private static native int getShapeTypeImpl(long var0);

    protected SoShape(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.boundingBoxIgnoring = ObjectManager.getManagedObjectFor(SoSFBool.class, SoShape.getFieldHandle(this.getNativeResourceHandle(), "boundingBoxIgnoring"));
    }

    static native String getClassTypeId();

    public static boolean isPrimitiveRestartAvailable() {
        return SoShape.isPrimitiveRestartAvailable(null);
    }

    public ShapeTypes getShapeType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ShapeTypes shapeTypes = IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, SoShape.getShapeTypeImpl(this.getNativeResourceHandle()));
            return shapeTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean isPrimitiveRestartAvailable(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoShape.isPrimitiveRestartAvailableImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static enum ShapeTypes implements IntegerValuedEnum
    {
        POINTS(ShapeTypes.getPOINTS()),
        LINES(ShapeTypes.getLINES()),
        POLYGONS(ShapeTypes.getPOLYGONS()),
        TEXT(ShapeTypes.getTEXT());

        private int value;

        private static native int getTEXT();

        private ShapeTypes(int n2) {
            this.value = n2;
        }

        private static native int getPOLYGONS();

        private static native int getPOINTS();

        private static native int getLINES();

        @Deprecated
        public static ShapeTypes fromValue(int n) {
            return ShapeTypes.valueOf(n);
        }

        public static ShapeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ShapeTypes.getPOINTS();
        }

        static /* synthetic */ int access$100() {
            return ShapeTypes.getLINES();
        }

        static /* synthetic */ int access$200() {
            return ShapeTypes.getPOLYGONS();
        }

        static /* synthetic */ int access$300() {
            return ShapeTypes.getTEXT();
        }
    }
}

