/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.projection;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoProjection;

public class SbProjection
extends Inventor {
    private static native boolean getFloatParameterImpl(long var0, int var2, float[] var3);

    private static native boolean getStringParameterImpl(long var0, int var2, String[] var3);

    private static native void inverseImpl(long var0, float[] var2);

    private static native boolean getProjectedBoundingBoxImpl(long var0, float[] var2);

    private static native void projectImpl(long var0, float[] var2);

    private static native int getNumStringParametersImpl(long var0);

    private static native void setNumFloatParametersImpl(long var0, int var2);

    private static native void setNumStringParametersImpl(long var0, int var2);

    private static native long getProjectionNodeImpl(long var0);

    private static native int getNumFloatParametersImpl(long var0);

    private static native void setParameterImpl(long var0, int var2, String var3);

    private static native long ctorImpl1(long var0);

    private static long ctorImpl2Sync(SbProjection sbProjection) {
        ObjectManager.globalLock.lock();
        try {
            long l = SbProjection.ctorImpl2(sbProjection != null ? sbProjection.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SbProjection.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImpl1Sync(SoProjection soProjection) {
        ObjectManager.globalLock.lock();
        try {
            long l = SbProjection.ctorImpl1(soProjection != null ? soProjection.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl2(long var0);

    private static native void initImpl(long var0);

    private static native void setParameterImpl1(long var0, int var2, float var3);

    private static native void exitImpl(long var0);

    private static native long ctorImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SbProjection(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void exit() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.exitImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f inverse() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.inverseImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public void init() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.initImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbProjection(SoProjection soProjection) {
        this(Inventor.ConstructorCommand.CreateInstance, SbProjection.ctorImpl1Sync(soProjection));
    }

    public SbProjection(SbProjection sbProjection) {
        this(Inventor.ConstructorCommand.CreateInstance, SbProjection.ctorImpl2Sync(sbProjection));
    }

    public SbProjection() {
        this(Inventor.ConstructorCommand.CreateInstance, SbProjection.ctorImplSync());
    }

    public SbBox3f getProjectedBoundingBox() {
        SbBox3f sbBox3f = new SbBox3f();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SbProjection.getProjectedBoundingBoxImpl(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbBox3f;
        }
        return null;
    }

    public void setParameter(int n, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.setParameterImpl1(this.getNativeResourceHandle(), n, f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumFloatParameters() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbProjection.getNumFloatParametersImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumStringParameters() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SbProjection.getNumStringParametersImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setNumStringParameters(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.setNumStringParametersImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setNumFloatParameters(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.setNumFloatParametersImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setParameter(int n, String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.setParameterImpl(this.getNativeResourceHandle(), n, string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f project() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbProjection.projectImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloatParameter(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SbProjection.getFloatParameterImpl(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringParameter(int n) {
        String[] stringArray = new String[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SbProjection.getStringParameterImpl(this.getNativeResourceHandle(), n, stringArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return stringArray[0];
        }
        return null;
    }

    public SoProjection getProjectionNode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoProjection soProjection = ObjectManager.getManagedObjectFor(SoProjection.class, SbProjection.getProjectionNodeImpl(this.getNativeResourceHandle()));
            return soProjection;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

