/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.projectors;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewVolume;

public class SbProjector
extends Inventor {
    private static native long copyImpl(long var0);

    private static native void intersectImpl(long var0, float[] var2, float[] var3);

    private static native void getWorkingSpaceImpl(long var0, float[] var2);

    private static native void setViewVolumeImpl(long var0, long var2);

    private static native void setWorkingSpaceImpl(long var0, float[] var2);

    private static native void getViewVolumeImpl(long var0, long var2);

    private static native void projectImpl(long var0, float[] var2, float[] var3);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SbProjector(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SbVec3f intersect(SbLine sbLine) {
        SbVec3f sbVec3f = new SbVec3f();
        SbProjector.intersectImpl(this.getNativeResourceHandle(), sbLine != null ? sbLine.array : null, sbVec3f.array);
        return sbVec3f;
    }

    public SbVec3f project(SbVec2f sbVec2f) {
        SbVec3f sbVec3f = new SbVec3f();
        SbProjector.projectImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, sbVec3f.array);
        return sbVec3f;
    }

    public void setWorkingSpace(SbMatrix sbMatrix) {
        SbProjector.setWorkingSpaceImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
    }

    public void setViewVolume(SbViewVolume sbViewVolume) {
        SbProjector.setViewVolumeImpl(this.getNativeResourceHandle(), sbViewVolume != null ? sbViewVolume.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SbMatrix getWorkingSpace() {
        SbMatrix sbMatrix = new SbMatrix();
        SbProjector.getWorkingSpaceImpl(this.getNativeResourceHandle(), sbMatrix.array);
        return sbMatrix;
    }

    public SbViewVolume getViewVolume() {
        SbViewVolume sbViewVolume = new SbViewVolume();
        SbProjector.getViewVolumeImpl(this.getNativeResourceHandle(), sbViewVolume.getNativeResourceHandle());
        return sbViewVolume;
    }

    public SbProjector copy() {
        return ObjectManager.getManagedObjectFor(SbProjector.class, SbProjector.copyImpl(this.getNativeResourceHandle()));
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

