/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.sensors.SoTimerQueueSensor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Timer;

public class SoAlarmSensor
extends SoTimerQueueSensor {
    protected AlarmSensorTask alarmTask = null;
    protected Timer swingTimer = null;
    protected boolean isScheduled = false;
    protected long triggerDate = 0L;
    protected long scheduleDate = 0L;

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoAlarmSensor.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    public SoAlarmSensor() {
        this(SoAlarmSensor.isTimerSensorWrapped() ? Inventor.ConstructorCommand.CreateInstance : Inventor.ConstructorCommand.DontCreateInstance, SoAlarmSensor.isTimerSensorWrapped() ? SoAlarmSensor.ctorImplSync() : 0L);
    }

    public SoAlarmSensor(Runnable runnable) {
        this();
        this.setTask(runnable);
    }

    @Override
    @Deprecated
    public void setDelay(long l) {
        if (SoAlarmSensor.isTimerSensorWrapped()) {
            SbTime sbTime = new SbTime();
            sbTime.setMsecValue(l);
            this.setTimeFromNow(sbTime);
        } else {
            this.delay_msec = l;
            this.triggerDate = 0L;
        }
    }

    private boolean onSetTime(SbTime sbTime) {
        if (!SoAlarmSensor.isTimerSensorWrapped()) {
            this.triggerDate = sbTime.getMsecValue();
            return true;
        }
        return false;
    }

    private boolean onSetTimeFromNow(SbTime sbTime) {
        if (!SoAlarmSensor.isTimerSensorWrapped()) {
            this.triggerDate = System.currentTimeMillis() + sbTime.getMsecValue();
            return true;
        }
        return false;
    }

    @Override
    public SbTime getTriggerTime() {
        if (SoAlarmSensor.isTimerSensorWrapped()) {
            return super.getTriggerTime();
        }
        if (this.triggerDate != 0L) {
            return new SbTime(0.001 * (double)this.triggerDate);
        }
        if (this.isScheduled) {
            return new SbTime(0.001 * (double)(this.scheduleDate + this.delay_msec));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule() {
        if (SoAlarmSensor.isTimerSensorWrapped()) {
            super.schedule();
        } else {
            this.unschedule();
            Object object = this.lock;
            synchronized (object) {
                this.alarmTask = new AlarmSensorTask();
                this.swingTimer = new Timer((int)this.delay_msec, this.alarmTask);
                this.swingTimer.setRepeats(false);
                this.scheduleDate = System.currentTimeMillis();
                if (this.triggerDate != 0L) {
                    long l = new Date().getTime();
                    long l2 = new Date(this.triggerDate).getTime();
                    if (l2 < l) {
                        throw new IllegalStateException("Sensor cannot be triggered in the past !");
                    }
                    this.swingTimer.setInitialDelay((int)(l2 - l));
                }
                this.swingTimer.start();
                this.isScheduled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unschedule() {
        if (SoAlarmSensor.isTimerSensorWrapped()) {
            super.unschedule();
        } else {
            if (!this.isScheduled) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.swingTimer.stop();
                this.isScheduled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScheduled() {
        if (SoAlarmSensor.isTimerSensorWrapped()) {
            return super.isScheduled();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.isScheduled;
        }
    }

    private static native void setTimeFromNowImpl(long var0, long var2);

    private static native void getTimeImpl(long var0, long var2);

    private static native void setTimeImpl(long var0, long var2);

    protected SoAlarmSensor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setTime(SbTime sbTime) {
        if (this.onSetTime(sbTime)) {
            return;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAlarmSensor.setTimeImpl(this.getNativeResourceHandle(), sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTimeFromNow(SbTime sbTime) {
        if (this.onSetTimeFromNow(sbTime)) {
            return;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAlarmSensor.setTimeFromNowImpl(this.getNativeResourceHandle(), sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbTime getTime() {
        if (!SoAlarmSensor.isTimerSensorWrapped()) {
            return new SbTime(0.001 * (double)this.triggerDate);
        }
        SbTime sbTime = new SbTime();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoAlarmSensor.getTimeImpl(this.getNativeResourceHandle(), sbTime.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbTime;
    }

    class AlarmSensorTask
    implements ActionListener {
        AlarmSensorTask() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SoAlarmSensor.this.isScheduled = false;
            if (SoAlarmSensor.this.task == null) {
                return;
            }
            SoAlarmSensor.this.task.run();
        }
    }
}

