/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoDelayQueueSensor;

public class SoDataSensor
extends SoDelayQueueSensor {
    protected Runnable finalTask = null;
    @Deprecated
    public static final int UNSPECIFIED = ChangeTypes.access$000();
    @Deprecated
    public static final int GROUP_ADD_CHILD = ChangeTypes.access$100();
    @Deprecated
    public static final int GROUP_INSERT_CHILD = ChangeTypes.access$200();
    @Deprecated
    public static final int GROUP_REPLACE_CHILD = ChangeTypes.access$300();
    @Deprecated
    public static final int GROUP_REMOVE_CHILD = ChangeTypes.access$400();
    @Deprecated
    public static final int GROUP_REMOVE_ALL_CHILDREN = ChangeTypes.access$500();
    @Deprecated
    public static final int FIELD_MULTIVALUE = ChangeTypes.access$600();

    public void setFinalTask(Runnable runnable) {
        this.finalTask = runnable;
        if (runnable != null) {
            ObjectManager.globalLock.lock();
            try {
                this.setFinalTaskNativ(this.getNativeResourceHandle());
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    private native void setFinalTaskNativ(long var1);

    private static void notifyFinal(long l) {
        SoDataSensor soDataSensor = ObjectManager.getManagedObjectFor(SoDataSensor.class, l);
        if (soDataSensor != null && soDataSensor.finalTask != null) {
            try {
                soDataSensor.finalTask.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static native void setTriggerPathFlagImpl(long var0, boolean var2);

    private static native int getTriggerChildIndexImpl(long var0);

    private static native long getTriggerPathImpl(long var0);

    private static native long getTriggerChildImpl(long var0);

    private static native boolean getTriggerFastEditInfoFlagImpl(long var0);

    private static native boolean getTriggerPathFlagImpl(long var0);

    private static native void setTriggerFastEditInfoFlagImpl(long var0, boolean var2);

    private static native long getTriggerNodeImpl(long var0);

    private static native int getTriggerFastEditInfoImpl(long var0);

    private static native int getTriggerTypeImpl(long var0);

    private static native int getTriggerMFieldStartIndexImpl(long var0);

    private static native long getTriggerFieldImpl(long var0);

    private static native int getTriggerMFieldNumValuesImpl(long var0);

    protected SoDataSensor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public int getTriggerFastEditInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSensor.getTriggerFastEditInfoImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getTriggerNode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoDataSensor.getTriggerNodeImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getTriggerFastEditInfoFlag() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSensor.getTriggerFastEditInfoFlagImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoField getTriggerField() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField soField = ObjectManager.getManagedObjectFor(SoField.class, SoDataSensor.getTriggerFieldImpl(this.getNativeResourceHandle()));
            return soField;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getTriggerChild() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoDataSensor.getTriggerChildImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTriggerFastEditInfoFlag(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSensor.setTriggerFastEditInfoFlagImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ChangeTypes getTriggerType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ChangeTypes changeTypes = IntegerValuedEnumHelper.fromIntValue(ChangeTypes.class, SoDataSensor.getTriggerTypeImpl(this.getNativeResourceHandle()));
            return changeTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getTriggerPathFlag() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSensor.getTriggerPathFlagImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getTriggerChildIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSensor.getTriggerChildIndexImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPath getTriggerPath() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoDataSensor.getTriggerPathImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getTriggerMFieldNumValues() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSensor.getTriggerMFieldNumValuesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTriggerPathFlag(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSensor.setTriggerPathFlagImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getTriggerMFieldStartIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSensor.getTriggerMFieldStartIndexImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum ChangeTypes implements IntegerValuedEnum
    {
        UNSPECIFIED(ChangeTypes.getUNSPECIFIED()),
        GROUP_ADD_CHILD(ChangeTypes.getGROUPADDCHILD()),
        GROUP_INSERT_CHILD(ChangeTypes.getGROUPINSERTCHILD()),
        GROUP_REPLACE_CHILD(ChangeTypes.getGROUPREPLACECHILD()),
        GROUP_REMOVE_CHILD(ChangeTypes.getGROUPREMOVECHILD()),
        GROUP_REMOVE_ALL_CHILDREN(ChangeTypes.getGROUPREMOVEALLCHILDREN()),
        FIELD_MULTIVALUE(ChangeTypes.getFIELDMULTIVALUE());

        private int value;

        private static native int getGROUPREMOVEALLCHILDREN();

        private static native int getGROUPREMOVECHILD();

        private ChangeTypes(int n2) {
            this.value = n2;
        }

        private static native int getFIELDMULTIVALUE();

        private static native int getGROUPADDCHILD();

        private static native int getUNSPECIFIED();

        private static native int getGROUPREPLACECHILD();

        private static native int getGROUPINSERTCHILD();

        @Deprecated
        public static ChangeTypes fromValue(int n) {
            return ChangeTypes.valueOf(n);
        }

        public static ChangeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ChangeTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ChangeTypes.getUNSPECIFIED();
        }

        static /* synthetic */ int access$100() {
            return ChangeTypes.getGROUPADDCHILD();
        }

        static /* synthetic */ int access$200() {
            return ChangeTypes.getGROUPINSERTCHILD();
        }

        static /* synthetic */ int access$300() {
            return ChangeTypes.getGROUPREPLACECHILD();
        }

        static /* synthetic */ int access$400() {
            return ChangeTypes.getGROUPREMOVECHILD();
        }

        static /* synthetic */ int access$500() {
            return ChangeTypes.getGROUPREMOVEALLCHILDREN();
        }

        static /* synthetic */ int access$600() {
            return ChangeTypes.getFIELDMULTIVALUE();
        }
    }
}

