/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.sensors.SoDataSensor;

public class SoFieldSensor
extends SoDataSensor {
    public SoFieldSensor(Runnable runnable) {
        this();
        this.setTask(runnable);
    }

    private static native long getAttachedFieldImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoFieldSensor.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void attachImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void detachImpl(long var0);

    protected SoFieldSensor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void attach(SoField soField) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFieldSensor.attachImpl(this.getNativeResourceHandle(), soField != null ? soField.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void detach() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFieldSensor.detachImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoField getAttachedField() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoField soField = ObjectManager.getManagedObjectFor(SoField.class, SoFieldSensor.getAttachedFieldImpl(this.getNativeResourceHandle()));
            return soField;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoFieldSensor() {
        this(Inventor.ConstructorCommand.CreateInstance, SoFieldSensor.ctorImplSync());
    }
}

